/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip;

import ch.qos.logback.classic.Level;
import java.io.File;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.ManipulationManager;
import org.commonjava.maven.ext.manip.ManipulationSession;
import org.commonjava.maven.ext.manip.io.PomIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cli {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ManipulationSession session;
    private ManipulationManager manipulationManager;
    private PomIO pomIO;
    private File target = new File(System.getProperty("user.dir"), "pom.xml");
    private Properties userProps;

    public static void main(String[] args) {
        new Cli().run(args);
    }

    private void run(String[] args) {
        Options options = new Options();
        options.addOption("h", false, "Print this help message.");
        options.addOption(Option.builder("d").longOpt("debug").desc("Enable debug").build());
        options.addOption(Option.builder("h").longOpt("help").desc("Print help").build());
        options.addOption(Option.builder("f").longOpt("file").hasArgs().numberOfArgs(1).desc("POM file").build());
        options.addOption(Option.builder("D").hasArgs().numberOfArgs(2).valueSeparator('=').desc("Java Properties").build());
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.logger.debug("Caught problem parsing ", e);
            System.err.println(e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("...", options);
            System.exit(1);
        }
        if (cmd.hasOption('h')) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("...", options);
            System.exit(1);
        }
        if (cmd.hasOption('D')) {
            this.userProps = cmd.getOptionProperties("D");
        }
        if (cmd.hasOption('f')) {
            this.target = new File(cmd.getOptionValue('f'));
        }
        this.createSession(this.target);
        if (cmd.hasOption('d')) {
            ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
            root.setLevel(Level.DEBUG);
        }
        if (!this.session.isEnabled()) {
            this.logger.info("Manipulation engine disabled via command-line option");
            return;
        }
        if (!this.target.exists()) {
            this.logger.info("Manipulation engine disabled. No project found.");
            return;
        }
        if (new File(this.target, ManipulationManager.MARKER_FILE).exists()) {
            this.logger.info("Skipping manipulation as previous execution found.");
            return;
        }
        try {
            this.manipulationManager.init(this.session);
            this.manipulationManager.scanAndApply(this.session);
        }
        catch (ManipulationException e) {
            this.logger.error("Unable to parse projects ", e);
            System.exit(1);
        }
    }

    private void createSession(File target) {
        try {
            DefaultPlexusContainer container = new DefaultPlexusContainer();
            MavenExecutionRequest req = new DefaultMavenExecutionRequest().setUserProperties(System.getProperties()).setUserProperties(this.userProps).setRemoteRepositories(Collections.<ArtifactRepository>emptyList());
            MavenSession mavenSession = new MavenSession((PlexusContainer)container, null, req, new DefaultMavenExecutionResult());
            mavenSession.getRequest().setPom(target);
            this.pomIO = container.lookup(PomIO.class);
            this.session = container.lookup(ManipulationSession.class);
            this.manipulationManager = container.lookup(ManipulationManager.class);
            this.session.setMavenSession(mavenSession);
        }
        catch (ComponentLookupException e) {
            this.logger.debug("Caught problem instantiating ", e);
            System.err.println("Unable to start Cli subsystem");
            System.exit(1);
            e.printStackTrace();
        }
        catch (PlexusContainerException e) {
            this.logger.debug("Caught problem instantiating ", e);
            System.err.println("Unable to start Cli subsystem");
            System.exit(1);
        }
    }
}

