/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.project.ProjectBuilder;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.ManipulationSession;
import org.commonjava.maven.ext.manip.impl.Manipulator;
import org.commonjava.maven.ext.manip.io.PomIO;
import org.commonjava.maven.ext.manip.model.Project;
import org.commonjava.maven.ext.manip.resolver.ExtensionInfrastructure;
import org.commonjava.maven.ext.manip.util.ManipulatorPriorityComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ManipulationManager.class)
public class ManipulationManager {
    static final String MARKER_PATH = "target";
    static final String MARKER_FILE = "target" + File.separatorChar + "pom-manip-ext-marker.txt";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private ProjectBuilder projectBuilder;
    @Requirement(role=Manipulator.class)
    private Map<String, Manipulator> manipulators;
    @Requirement(role=ExtensionInfrastructure.class)
    private Map<String, ExtensionInfrastructure> infrastructure;
    @Requirement
    private PomIO pomIO;
    private List<Manipulator> orderedManipulators;

    public void init(ManipulationSession session) throws ManipulationException {
        for (ExtensionInfrastructure infra : this.infrastructure.values()) {
            infra.init(session);
        }
        HashMap<Manipulator, String> revMap = new HashMap<Manipulator, String>();
        for (Map.Entry<String, Manipulator> entry : this.manipulators.entrySet()) {
            revMap.put(entry.getValue(), entry.getKey());
        }
        this.orderedManipulators = new ArrayList(revMap.keySet());
        Collections.sort(this.orderedManipulators, new ManipulatorPriorityComparator());
        for (Manipulator manipulator : this.orderedManipulators) {
            this.logger.debug("Initialising manipulator " + manipulator.getClass().getSimpleName());
            manipulator.init(session);
        }
    }

    public void scanAndApply(ManipulationSession session) throws ManipulationException {
        List<Project> projects = this.pomIO.parseProject(session.getPom());
        this.scan(projects, session);
        for (Project project : projects) {
            this.logger.debug("Got " + project + " (POM: " + project.getPom() + ")");
            this.logger.debug("### Project is execution root " + project.isExecutionRoot() + " and is inheritance root " + project.isInheritanceRoot());
        }
        Set<Project> changed = this.applyManipulations(projects, session);
        if (!changed.isEmpty()) {
            this.logger.info("Maven-Manipulation-Extension: Rewrite changed: " + projects);
            this.pomIO.rewritePOMs(changed);
            try {
                new File(session.getTargetDir().getParentFile(), MARKER_PATH).mkdirs();
                new File(session.getTargetDir().getParentFile(), MARKER_FILE).createNewFile();
            }
            catch (IOException e) {
                throw new ManipulationException("Marker file creation failed", (Throwable)e, new Object[0]);
            }
        }
        this.logger.info("Maven-Manipulation-Extension: Finished.");
    }

    public void scan(List<Project> projects, ManipulationSession session) throws ManipulationException {
        session.setProjects(projects);
        for (Manipulator manipulator : this.orderedManipulators) {
            manipulator.scan(projects, session);
        }
    }

    public Set<Project> applyManipulations(List<Project> projects, ManipulationSession session) throws ManipulationException {
        HashSet<Project> changed = new HashSet<Project>();
        for (Manipulator manipulator : this.orderedManipulators) {
            Set<Project> mChanged = manipulator.applyChanges(projects, session);
            if (mChanged == null) continue;
            changed.addAll(mChanged);
        }
        if (changed.isEmpty()) {
            this.logger.info("Maven-Manipulation-Extension: No changes.");
        }
        return changed;
    }
}

