/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.ManipulationSession;
import org.commonjava.maven.ext.manip.impl.Manipulator;
import org.commonjava.maven.ext.manip.io.ModelIO;
import org.commonjava.maven.ext.manip.model.Project;
import org.commonjava.maven.ext.manip.state.PluginState;
import org.commonjava.maven.ext.manip.state.State;
import org.commonjava.maven.ext.manip.util.IdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=Manipulator.class, hint="plugin-manipulator")
public class PluginManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Requirement
    protected ModelIO effectiveModelBuilder;
    private PluginState.Precedence configPrecedence = PluginState.Precedence.REMOTE;

    @Override
    public void init(ManipulationSession session) {
        Properties userProps = session.getUserProperties();
        session.setState(new PluginState(userProps));
        switch (PluginState.Precedence.valueOf(userProps.getProperty("pluginManagementPrecedence", PluginState.Precedence.REMOTE.toString()).toUpperCase())) {
            case REMOTE: {
                this.configPrecedence = PluginState.Precedence.REMOTE;
                break;
            }
            case LOCAL: {
                this.configPrecedence = PluginState.Precedence.LOCAL;
            }
        }
    }

    @Override
    public void scan(List<Project> projects, ManipulationSession session) throws ManipulationException {
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects, ManipulationSession session) throws ManipulationException {
        PluginState state = session.getState(PluginState.class);
        if (!session.isEnabled() || !state.isEnabled()) {
            this.logger.debug(this.getClass().getSimpleName() + ": Nothing to do!");
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        Map<ProjectRef, Plugin> overrides = this.loadRemoteBOM(state, session);
        for (Project project : projects) {
            Model model = project.getModel();
            if (overrides.size() <= 0) continue;
            this.apply(session, project, model, overrides);
            changed.add(project);
        }
        return changed;
    }

    protected Map<ProjectRef, Plugin> loadRemoteBOM(State state, ManipulationSession session) throws ManipulationException {
        LinkedHashMap<ProjectRef, Plugin> overrides = new LinkedHashMap<ProjectRef, Plugin>();
        List<ProjectVersionRef> gavs = ((PluginState)state).getRemotePluginMgmt();
        if (gavs == null || gavs.isEmpty()) {
            return overrides;
        }
        ListIterator<ProjectVersionRef> iter = gavs.listIterator(gavs.size());
        while (iter.hasPrevious()) {
            ProjectVersionRef ref = iter.previous();
            overrides.putAll(this.effectiveModelBuilder.getRemotePluginVersionOverrides(ref, session));
        }
        return overrides;
    }

    protected void apply(ManipulationSession session, Project project, Model model, Map<ProjectRef, Plugin> override) throws ManipulationException {
        this.logger.info("Applying plugin changes to: " + IdUtils.ga(project));
        if (project.isInheritanceRoot()) {
            PluginManagement pluginManagement;
            Build build = model.getBuild();
            if (build == null) {
                build = new Build();
                model.setBuild(build);
                this.logger.info("Created new Build for model " + model.getId());
            }
            if ((pluginManagement = model.getBuild().getPluginManagement()) == null) {
                pluginManagement = new PluginManagement();
                model.getBuild().setPluginManagement(pluginManagement);
                this.logger.info("Created new Plugin Management for model " + model.getId());
            }
            this.applyOverrides(true, pluginManagement.getPlugins(), override);
        }
        if (model.getBuild() != null) {
            List<Plugin> projectPlugins = model.getBuild().getPlugins();
            this.applyOverrides(false, projectPlugins, override);
        }
    }

    protected void applyOverrides(boolean pluginMgmt, List<Plugin> plugins, Map<ProjectRef, Plugin> pluginVersionOverrides) throws ManipulationException {
        if (plugins == null) {
            throw new ManipulationException("Original plugins should not be null", new String[0]);
        }
        for (Plugin override : pluginVersionOverrides.values()) {
            int index = plugins.indexOf(override);
            this.logger.debug("plugin override" + override + " and index " + index);
            if (index != -1) {
                ProjectRef groupIdArtifactId = new ProjectRef(override.getGroupId(), override.getArtifactId());
                Plugin plugin = plugins.get(index);
                if (override.getConfiguration() != null) {
                    if (pluginMgmt && plugin.getConfiguration() == null) {
                        plugin.setConfiguration(override.getConfiguration());
                        this.logger.debug("Altered plugin configuration: " + groupIdArtifactId + "=" + plugin.getConfiguration());
                    } else if (pluginMgmt && plugin.getConfiguration() != null) {
                        this.logger.debug("Existing plugin configuration: " + plugin.getConfiguration());
                        if (!(plugin.getConfiguration() instanceof Xpp3Dom) || !(override.getConfiguration() instanceof Xpp3Dom)) {
                            throw new ManipulationException("Incorrect DOM type " + plugin.getConfiguration().getClass().getName() + " and" + override.getConfiguration().getClass().getName(), new String[0]);
                        }
                        if (this.configPrecedence == PluginState.Precedence.REMOTE) {
                            plugin.setConfiguration(Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)override.getConfiguration(), (Xpp3Dom)plugin.getConfiguration()));
                        } else if (this.configPrecedence == PluginState.Precedence.LOCAL) {
                            plugin.setConfiguration(Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)plugin.getConfiguration(), (Xpp3Dom)override.getConfiguration()));
                        }
                        this.logger.debug("Altered plugin configuration: " + groupIdArtifactId + "=" + plugin.getConfiguration());
                    }
                } else {
                    this.logger.debug("No remote configuration to inject from " + override.toString());
                }
                if (!pluginMgmt && plugin.getVersion() == null) continue;
                plugin.setVersion(override.getVersion());
                this.logger.info("Altered plugin version: " + groupIdArtifactId + "=" + override.getVersion());
                continue;
            }
            if (!pluginMgmt || override.getConfiguration() == null) continue;
            plugins.add(override);
            this.logger.info("Added plugin version: " + override.getKey() + "=" + override.getVersion());
        }
    }

    @Override
    public int getExecutionIndex() {
        return 60;
    }
}

