/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Profile;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.ManipulationSession;
import org.commonjava.maven.ext.manip.impl.Manipulator;
import org.commonjava.maven.ext.manip.impl.VersionCalculator;
import org.commonjava.maven.ext.manip.model.Project;
import org.commonjava.maven.ext.manip.state.VersioningState;
import org.commonjava.maven.ext.manip.util.IdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=Manipulator.class, hint="version-manipulator")
public class ProjectVersioningManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Requirement
    protected VersionCalculator calculator;

    protected ProjectVersioningManipulator() {
    }

    public ProjectVersioningManipulator(VersionCalculator calculator) {
        this.calculator = calculator;
    }

    @Override
    public void scan(List<Project> projects, ManipulationSession session) throws ManipulationException {
        VersioningState state = session.getState(VersioningState.class);
        if (!session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("Version Manipulator: Nothing to do!");
            return;
        }
        this.logger.info("Version Manipulator: Calculating the necessary versioning changes.");
        Map<String, String> versionsByGAV = this.calculator.calculateVersioningChanges(projects, session);
        state.setVersioningChanges(versionsByGAV);
    }

    @Override
    public void init(ManipulationSession session) {
        Properties userProps = session.getUserProperties();
        session.setState(new VersioningState(userProps));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects, ManipulationSession session) throws ManipulationException {
        VersioningState state = session.getState(VersioningState.class);
        if (!session.isEnabled() || state == null || !state.isEnabled()) {
            this.logger.debug(this.getClass().getSimpleName() + ": Nothing to do!");
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        for (Project project : projects) {
            String ga = IdUtils.ga(project);
            this.logger.info(this.getClass().getSimpleName() + " applying changes to: " + ga);
            if (!this.applyVersioningChanges(project, state)) continue;
            changed.add(project);
        }
        return changed;
    }

    protected boolean applyVersioningChanges(Project project, VersioningState state) throws ManipulationException {
        String newVersion;
        boolean changed = false;
        Model model = project.getModel();
        Map<String, String> versionsByGAV = state.getVersioningChanges();
        if (versionsByGAV == null || versionsByGAV.isEmpty()) {
            return false;
        }
        if (model == null) {
            return false;
        }
        this.logger.info("Looking for applicable versioning changes in: " + IdUtils.gav(model));
        String g = model.getGroupId();
        String v = model.getVersion();
        Parent parent = model.getParent();
        if (g == null && parent != null) {
            g = parent.getGroupId();
        }
        if (v == null && parent != null) {
            v = parent.getVersion();
        }
        if (parent != null && parent.getVersion() != null) {
            String parentGAV = IdUtils.gav(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            this.logger.info("Looking for parent: " + parentGAV);
            if (versionsByGAV.containsKey(parentGAV)) {
                newVersion = versionsByGAV.get(parentGAV);
                parent.setVersion(newVersion);
                changed = true;
            }
        }
        String gav = IdUtils.gav(g, model.getArtifactId(), v);
        if (model.getVersion() != null) {
            newVersion = versionsByGAV.get(gav);
            this.logger.info("Looking for new version: " + gav + " (found: " + newVersion + ")");
            if (newVersion != null && model.getVersion() != null) {
                model.setVersion(newVersion);
                this.logger.info("Changed main version in " + IdUtils.gav(model));
                changed = true;
            }
        } else if (!changed && model.getVersion() == null && project.isInheritanceRoot()) {
            newVersion = versionsByGAV.get(gav);
            this.logger.info("Looking to force inject new version for : " + gav + " (found: " + newVersion + ")");
            if (newVersion != null) {
                model.setVersion(newVersion);
                this.logger.info("Force inject main version in " + IdUtils.gav(model));
                changed = true;
            }
        }
        HashSet<ModelBase> bases = new HashSet<ModelBase>();
        bases.add(model);
        List<Profile> profiles = model.getProfiles();
        if (profiles != null) {
            bases.addAll(profiles);
        }
        StringSearchInterpolator interp = new StringSearchInterpolator();
        if (model.getProperties() != null) {
            interp.addValueSource(new PropertiesBasedValueSource(model.getProperties()));
        }
        List<String> prefixes = Arrays.asList("pom", "project");
        interp.addValueSource(new PrefixedObjectValueSource(prefixes, model, true));
        PrefixAwareRecursionInterceptor ri = new PrefixAwareRecursionInterceptor(prefixes, true);
        for (ModelBase base : bases) {
            String newVersion2;
            DependencyManagement dm = base.getDependencyManagement();
            if (dm != null && dm.getDependencies() != null) {
                for (Dependency d : dm.getDependencies()) {
                    gav = IdUtils.gav(this.interpolate(d.getGroupId(), ri, interp), this.interpolate(d.getArtifactId(), ri, interp), this.interpolate(d.getVersion(), ri, interp));
                    newVersion2 = versionsByGAV.get(gav);
                    if (newVersion2 == null) continue;
                    d.setVersion(newVersion2);
                    this.logger.info("Changed managed: " + d + " in " + base);
                    changed = true;
                }
            }
            if (base.getDependencies() == null) continue;
            for (Dependency d : base.getDependencies()) {
                gav = IdUtils.gav(this.interpolate(d.getGroupId(), ri, interp), this.interpolate(d.getArtifactId(), ri, interp), this.interpolate(d.getVersion(), ri, interp));
                newVersion2 = versionsByGAV.get(gav);
                if (newVersion2 == null || d.getVersion() == null) continue;
                d.setVersion(newVersion2);
                this.logger.info("Changed: " + d + " in " + base);
                changed = true;
            }
        }
        if (changed) {
            this.logger.info("Applied versioning changes to: " + IdUtils.gav(model));
        }
        return changed;
    }

    private String interpolate(String src, RecursionInterceptor ri, StringSearchInterpolator interp) throws ManipulationException {
        try {
            return interp.interpolate(src, ri);
        }
        catch (InterpolationException e) {
            throw new ManipulationException("Failed to interpolate: %s. Reason: %s", (Throwable)e, src, e.getMessage());
        }
    }

    @Override
    public int getExecutionIndex() {
        return 10;
    }
}

