/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Character[] DEFAULT_DELIMITERS = new Character[]{Character.valueOf('.'), Character.valueOf('-'), Character.valueOf('_')};
    private static final char OSGI_VERSION_DELIMITER = '.';
    private static final String DELIMITER_REGEX = "[\\.\\-_]?";
    private static final String MMM_REGEX = "(\\d+)([\\.\\-_]?(\\d+)?([\\.\\-_]?(\\d+)?)?)?";
    private static final Pattern mmmPattern = Pattern.compile("(\\d+)([\\.\\-_]?(\\d+)?([\\.\\-_]?(\\d+)?)?)?");
    private static final String SNAPSHOT_SUFFIX = "SNAPSHOT";
    private static final String QUALIFIER_REGEX = "(.*?)(\\d+)?([\\.\\-_]?)?((?i:SNAPSHOT))?$";
    private static final Pattern qualifierPattern = Pattern.compile("(.*?)(\\d+)?([\\.\\-_]?)?((?i:SNAPSHOT))?$");
    private static final String OSGI_VERSION_REGEX = "(\\d+)(\\.\\d+(\\.\\d+([\\.][\\p{Alnum}|\\-|_]+)?)?)?";
    private static final Pattern osgiPattern = Pattern.compile("(\\d+)(\\.\\d+(\\.\\d+([\\.][\\p{Alnum}|\\-|_]+)?)?)?");
    private List<Character> versionStringDelimiters = Arrays.asList(DEFAULT_DELIMITERS);
    private final String originalVersion;
    private String originalMMM;
    private String majorVersion;
    private String minorVersion;
    private String microVersion;
    private String originalQualifier;
    private String originalMMMDelimiter = "";
    private String qualifier;
    private String qualifierBase;
    private String buildNumber;
    private String snapshot;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean numericVersion = true;

    public Version(String version) {
        this.originalVersion = version;
        this.logger.debug("Parsing version: " + this.originalVersion);
        this.parseVersion(this.originalVersion);
        this.logger.debug("Major: " + this.getMajorVersion() + ", Minor: " + this.getMinorVersion() + ",  Micro: " + this.getMicroVersion());
        this.logger.debug("Qualifier: " + this.getQualifier() + ", Base: " + this.getQualifierBase() + ", BuildNum: " + this.getBuildNumber());
    }

    private final void parseVersion(String version) {
        int qualifierIndex = this.getQualifierIndex(version);
        if (qualifierIndex > 0 && this.versionStringDelimiters.contains(Character.valueOf(version.charAt(qualifierIndex - 1)))) {
            this.originalMMMDelimiter = Character.toString(version.charAt(qualifierIndex - 1));
            this.originalMMM = version.substring(0, qualifierIndex - 1);
        } else {
            this.originalMMM = version.substring(0, qualifierIndex);
        }
        this.qualifier = this.originalQualifier = version.substring(qualifierIndex);
        this.parseMMM(this.originalMMM);
        this.parseQualifier(this.originalQualifier);
    }

    private int getQualifierIndex(String version) {
        int QUALIFIER_NOT_FOUND = version.length();
        int delimiterCount = 0;
        for (int qualifierIndex = 0; qualifierIndex < version.length(); ++qualifierIndex) {
            if (this.versionStringDelimiters.contains(Character.valueOf(version.charAt(qualifierIndex)))) {
                ++delimiterCount;
                continue;
            }
            if (Version.isNumeric(Character.toString(version.charAt(qualifierIndex)))) continue;
            return qualifierIndex;
        }
        return QUALIFIER_NOT_FOUND;
    }

    private void parseMMM(String mmm) {
        String micro;
        this.majorVersion = "0";
        this.minorVersion = "0";
        this.microVersion = "0";
        if (this.isEmpty(mmm)) {
            this.numericVersion = false;
            return;
        }
        Matcher mmmMatcher = mmmPattern.matcher(mmm);
        mmmMatcher.matches();
        this.majorVersion = mmmMatcher.group(1);
        String minor = mmmMatcher.group(3);
        if (!this.isEmpty(minor)) {
            this.minorVersion = minor;
        }
        if (!this.isEmpty(micro = mmmMatcher.group(5))) {
            this.microVersion = micro;
        }
    }

    private void parseQualifier(String qualifier) {
        if (this.isEmpty(qualifier)) {
            return;
        }
        Matcher qualifierMatcher = qualifierPattern.matcher(qualifier);
        qualifierMatcher.matches();
        this.qualifierBase = qualifierMatcher.group(1);
        this.buildNumber = qualifierMatcher.group(2);
        this.snapshot = qualifierMatcher.group(4);
    }

    private String removeLastDelimiters(String partialVersionString) {
        while (!this.isEmpty(partialVersionString) && this.versionStringDelimiters.contains(Character.valueOf(partialVersionString.charAt(partialVersionString.length() - 1)))) {
            partialVersionString = partialVersionString.substring(0, partialVersionString.length() - 1);
        }
        return partialVersionString;
    }

    private boolean isEmpty(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().equals("");
    }

    public static boolean isNumeric(String str) {
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidOSGi() {
        Matcher osgiMatcher = osgiPattern.matcher(this.originalVersion);
        return osgiMatcher.matches();
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public String getMicroVersion() {
        return this.microVersion;
    }

    private void updateQualifier() {
        StringBuilder updatedQualifier = new StringBuilder();
        if (!this.isEmpty(this.getQualifierBase())) {
            updatedQualifier.append(this.getQualifierBase());
            if (!(this.isEmpty(this.getBuildNumber()) && !this.isSnapshot() || this.versionStringDelimiters.contains(Character.valueOf(this.getQualifierBase().charAt(this.getQualifierBase().length() - 1))))) {
                updatedQualifier.append('-');
            }
        }
        if (!this.isEmpty(this.getBuildNumber())) {
            updatedQualifier.append(this.getBuildNumber());
            if (this.isSnapshot()) {
                updatedQualifier.append('-');
            }
        }
        if (this.isSnapshot()) {
            updatedQualifier.append(this.snapshot);
        }
        this.qualifier = updatedQualifier.toString();
    }

    public String getOriginalVersion() {
        return this.originalVersion;
    }

    public String getOriginalMMM() {
        return this.originalMMM;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getQualifierBase() {
        return this.qualifierBase;
    }

    public String getVersionString() {
        if (this.isEmpty(this.getQualifier())) {
            return this.originalVersion;
        }
        if (this.isEmpty(this.originalMMM)) {
            return this.getQualifier();
        }
        StringBuffer versionString = new StringBuffer();
        versionString.append(this.originalMMM);
        if (this.isEmpty(this.originalMMMDelimiter)) {
            versionString.append('.');
        } else {
            versionString.append(this.originalMMMDelimiter);
        }
        versionString.append(this.getQualifier());
        return versionString.toString();
    }

    public String getOSGiVersionString() {
        if (this.isValidOSGi() && !this.hasQualifier()) {
            return this.originalVersion;
        }
        StringBuilder osgiVersion = new StringBuilder();
        if (this.numericVersion) {
            osgiVersion.append(this.getThreePartMMM());
        }
        if (!this.isEmpty(this.getQualifier())) {
            if (this.numericVersion) {
                osgiVersion.append('.');
            }
            osgiVersion.append(this.getOSGiQualifier());
        }
        return osgiVersion.toString();
    }

    private String getThreePartMMM() {
        StringBuffer mmm = new StringBuffer();
        mmm.append(this.getMajorVersion());
        if (!this.isEmpty(this.getMinorVersion())) {
            mmm.append('.');
            mmm.append(this.getMinorVersion());
        }
        if (!this.isEmpty(this.getMicroVersion())) {
            mmm.append('.');
            mmm.append(this.getMicroVersion());
        }
        return mmm.toString();
    }

    private String getOSGiQualifier() {
        if (this.getQualifier() == null) {
            return null;
        }
        return this.getQualifier().replace('.', '-');
    }

    public boolean isSnapshot() {
        return SNAPSHOT_SUFFIX.equalsIgnoreCase(this.snapshot);
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public boolean hasBuildNumber() {
        return !this.isEmpty(this.getBuildNumber());
    }

    public boolean hasQualifier() {
        return !this.isEmpty(this.getQualifier());
    }

    public void appendQualifierSuffix(String suffix) {
        if (suffix == null) {
            return;
        }
        this.logger.debug("Applying suffix: " + suffix + " to version " + this.getVersionString());
        Matcher suffixMatcher = qualifierPattern.matcher(suffix);
        if (!suffixMatcher.matches()) {
            return;
        }
        String suffixBase = suffixMatcher.group(1);
        String buildNumber = suffixMatcher.group(2);
        String snapshot = suffixMatcher.group(4);
        String suffixBaseNoDelim = this.removeLastDelimiters(suffixBase);
        String suffixMatchRegex = "(.*?)(" + Pattern.quote(suffixBaseNoDelim) + ")(" + DELIMITER_REGEX + ")";
        String oldQualifierBase = this.getQualifierBase();
        if (this.isEmpty(this.getQualifier())) {
            this.qualifierBase = suffixBase;
        } else if (!Pattern.matches(suffixMatchRegex, oldQualifierBase)) {
            String newQualifierBase = oldQualifierBase;
            if (!this.isEmpty(this.getBuildNumber())) {
                newQualifierBase = newQualifierBase + this.getBuildNumber();
                this.buildNumber = null;
            }
            if (!this.isEmpty(newQualifierBase) && !this.versionStringDelimiters.contains(Character.valueOf(newQualifierBase.charAt(newQualifierBase.length() - 1)))) {
                newQualifierBase = newQualifierBase + "-";
            }
            this.qualifierBase = newQualifierBase = newQualifierBase + suffixBase;
        }
        if (!this.isEmpty(buildNumber)) {
            this.buildNumber = buildNumber;
        }
        if (SNAPSHOT_SUFFIX.equalsIgnoreCase(snapshot)) {
            this.snapshot = SNAPSHOT_SUFFIX;
        }
        this.updateQualifier();
        this.logger.debug("New version string: " + this.getVersionString());
    }

    public void setBuildNumber(String buildNumber) {
        if (buildNumber == null || Version.isNumeric(buildNumber)) {
            this.buildNumber = buildNumber;
            this.updateQualifier();
        }
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot ? SNAPSHOT_SUFFIX : null;
        this.updateQualifier();
    }

    public int findHighestMatchingBuildNumber(Version version, Set<String> versionSet) {
        int highestBuildNum = 0;
        StringBuffer versionPatternBuf = new StringBuffer();
        versionPatternBuf.append("(");
        versionPatternBuf.append(Pattern.quote(this.getOriginalMMM()));
        versionPatternBuf.append("([\\.\\-_]?0)*");
        versionPatternBuf.append(")?");
        versionPatternBuf.append(DELIMITER_REGEX);
        if (version.getQualifierBase() != null) {
            versionPatternBuf.append(Pattern.quote(version.getQualifierBase()));
            versionPatternBuf.append(DELIMITER_REGEX);
        }
        versionPatternBuf.append("(\\d+)");
        String candidatePatternStr = versionPatternBuf.toString();
        this.logger.debug("Using pattern: '{}' to find compatible versions from metadata.", (Object)candidatePatternStr);
        Pattern candidateSuffixPattern = Pattern.compile(candidatePatternStr);
        for (String compareVersion : versionSet) {
            String buildNumberStr;
            int compareBuildNum;
            Matcher candidateSuffixMatcher = candidateSuffixPattern.matcher(compareVersion);
            if (!candidateSuffixMatcher.matches() || (compareBuildNum = Integer.parseInt(buildNumberStr = candidateSuffixMatcher.group(3))) <= highestBuildNum) continue;
            highestBuildNum = compareBuildNum;
        }
        return highestBuildNum;
    }

    public int getIntegerBuildNumber() {
        if (this.isEmpty(this.buildNumber)) {
            return 0;
        }
        return Integer.parseInt(this.buildNumber);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Version: ");
        buffer.append(this.getVersionString());
        buffer.append(", OSGi Version: ");
        buffer.append(this.getOSGiVersionString());
        return buffer.toString();
    }
}

