/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.ManipulationSession;
import org.commonjava.maven.ext.manip.resolver.GalleyAPIWrapper;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.DependencyView;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.model.Transfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ModelIO.class)
public class ModelIO {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private ModelBuilder modelBuilder;
    @Requirement
    private GalleyAPIWrapper galleyWrapper;

    protected ModelIO() {
    }

    public Model resolveRawModel(ProjectVersionRef ref) throws ManipulationException {
        Transfer transfer;
        try {
            transfer = this.galleyWrapper.resolveArtifact(ref.asPomArtifact());
        }
        catch (TransferException e) {
            throw new ManipulationException("Failed to resolve POM: %s.\n--> %s", (Throwable)e, ref, e.getMessage());
        }
        if (transfer == null) {
            throw new ManipulationException("Failed to resolve POM: " + ref.asPomArtifact(), new String[0]);
        }
        InputStream in = null;
        try {
            in = transfer.openInputStream();
            Model model = new MavenXpp3Reader().read(in);
            return model;
        }
        catch (IOException e) {
            throw new ManipulationException("Failed to build model for POM: %s.\n--> %s", (Throwable)e, ref, e.getMessage());
        }
        catch (XmlPullParserException e) {
            throw new ManipulationException("Failed to build model for POM: %s.\n--> %s", (Throwable)e, ref, e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public Map<ProjectRef, String> getRemoteDependencyVersionOverrides(ProjectVersionRef ref, ManipulationSession session) throws ManipulationException {
        this.logger.debug("Resolving dependency management GAV: " + ref);
        LinkedHashMap<ProjectRef, String> versionOverrides = new LinkedHashMap<ProjectRef, String>();
        try {
            MavenPomView pomView = this.galleyWrapper.readPomView(ref);
            List<DependencyView> deps = pomView.getAllManagedDependencies();
            if (deps == null || deps.isEmpty()) {
                throw new ManipulationException("Attempting to align to a BOM that does not have a dependencyManagement section", new String[0]);
            }
            for (DependencyView dep : deps) {
                versionOverrides.put(dep.asVersionlessArtifactRef(), dep.getVersion());
                this.logger.debug("Added version override for: " + dep.asProjectRef().toString() + ":" + dep.getVersion());
            }
        }
        catch (GalleyMavenException e) {
            throw new ManipulationException("Unable to resolve: %s", (Throwable)e, ref);
        }
        return versionOverrides;
    }

    public Properties getRemotePropertyMappingOverrides(ProjectVersionRef ref, ManipulationSession session) throws ManipulationException {
        this.logger.debug("Resolving remote property mapping POM: " + ref);
        Model m = this.resolveRawModel(ref);
        this.logger.debug("Returning override of " + m.getProperties());
        return m.getProperties();
    }

    public Map<ProjectRef, Plugin> getRemotePluginVersionOverrides(ProjectVersionRef ref, ManipulationSession session) throws ManipulationException {
        this.logger.debug("Resolving remote plugin management POM: " + ref);
        Model m = this.resolveRawModel(ref);
        HashMap<ProjectRef, Plugin> versionOverrides = new HashMap<ProjectRef, Plugin>();
        if (m.getBuild() != null && m.getBuild().getPluginManagement() != null) {
            this.logger.debug("Returning override of " + m.getBuild().getPluginManagement().getPlugins());
            for (Plugin p : m.getBuild().getPluginManagement().getPlugins()) {
                ProjectRef pr = new ProjectRef(p.getGroupId(), p.getArtifactId());
                if (p.getVersion().startsWith("${")) {
                    String newVersion = this.resolveProperty(m.getProperties(), p.getVersion());
                    this.logger.debug("Replacing plugin override version " + p.getVersion() + " with " + newVersion);
                    p.setVersion(newVersion);
                }
                versionOverrides.put(pr, p);
                if (p.getConfiguration() != null) {
                    this.processChildren(m, (Xpp3Dom)p.getConfiguration());
                }
                this.logger.debug("Added plugin override for: " + pr.toString() + ":" + p.getVersion() + " with configuration\n" + p.getConfiguration());
            }
        } else {
            throw new ManipulationException("Attempting to align to a BOM that does not have a pluginManagement section", new String[0]);
        }
        return versionOverrides;
    }

    private void processChildren(Model model, Xpp3Dom parent) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Xpp3Dom child = parent.getChild(i);
            if (child.getChildCount() > 0) {
                this.processChildren(model, child);
            }
            if (child.getValue() == null || !child.getValue().startsWith("${")) continue;
            String replacement = this.resolveProperty(model.getProperties(), child.getValue());
            this.logger.debug("Replacing child value " + child.getValue() + " with " + replacement);
            child.setValue(replacement);
        }
    }

    private String resolveProperty(Properties p, String key) {
        String result = "";
        String child = key.substring(2, key.length() - 1);
        if (p.containsKey(child) && (result = p.getProperty(child)).startsWith("${")) {
            result = this.resolveProperty(p, result);
        }
        return result;
    }
}

