/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.resolver;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.maven.repository.MirrorSelector;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.ManipulationSession;
import org.commonjava.maven.ext.manip.resolver.ExtensionInfrastructure;
import org.commonjava.maven.ext.manip.resolver.MavenLocationExpander;
import org.commonjava.maven.galley.auth.MemoryPasswordManager;
import org.commonjava.maven.galley.cache.FileCacheProvider;
import org.commonjava.maven.galley.event.NoOpFileEventManager;
import org.commonjava.maven.galley.filearc.FileTransport;
import org.commonjava.maven.galley.filearc.ZipJarTransport;
import org.commonjava.maven.galley.internal.TransferManagerImpl;
import org.commonjava.maven.galley.internal.xfer.DownloadHandler;
import org.commonjava.maven.galley.internal.xfer.ExistenceHandler;
import org.commonjava.maven.galley.internal.xfer.ListingHandler;
import org.commonjava.maven.galley.internal.xfer.UploadHandler;
import org.commonjava.maven.galley.io.HashedLocationPathGenerator;
import org.commonjava.maven.galley.io.NoOpTransferDecorator;
import org.commonjava.maven.galley.maven.ArtifactManager;
import org.commonjava.maven.galley.maven.internal.ArtifactManagerImpl;
import org.commonjava.maven.galley.maven.internal.ArtifactMetadataManagerImpl;
import org.commonjava.maven.galley.maven.internal.defaults.StandardMaven304PluginDefaults;
import org.commonjava.maven.galley.maven.internal.defaults.StandardMavenPluginImplications;
import org.commonjava.maven.galley.maven.internal.type.StandardTypeMapper;
import org.commonjava.maven.galley.maven.internal.version.VersionResolverImpl;
import org.commonjava.maven.galley.maven.model.view.XPathManager;
import org.commonjava.maven.galley.maven.parse.MavenMetadataReader;
import org.commonjava.maven.galley.maven.parse.MavenPomReader;
import org.commonjava.maven.galley.maven.parse.XMLInfrastructure;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.nfc.MemoryNotFoundCache;
import org.commonjava.maven.galley.spi.event.FileEventManager;
import org.commonjava.maven.galley.spi.io.PathGenerator;
import org.commonjava.maven.galley.spi.io.TransferDecorator;
import org.commonjava.maven.galley.spi.transport.LocationExpander;
import org.commonjava.maven.galley.spi.transport.Transport;
import org.commonjava.maven.galley.transport.TransportManagerImpl;
import org.commonjava.maven.galley.transport.htcli.HttpClientTransport;
import org.commonjava.maven.galley.transport.htcli.HttpImpl;

@Component(role=ExtensionInfrastructure.class, hint="galley")
public class GalleyInfrastructure
implements ExtensionInfrastructure {
    @Requirement
    private MirrorSelector mirrorSelector;
    private MavenPomReader pomReader;
    private LocationExpander locationExpander;
    private ArtifactManager artifactManager;
    private MavenMetadataReader metadataReader;
    private XMLInfrastructure xml;
    private XPathManager xpaths;

    protected GalleyInfrastructure() {
    }

    public GalleyInfrastructure(ManipulationSession session) throws ManipulationException {
        this.init(session);
    }

    public GalleyInfrastructure(ManipulationSession session, MirrorSelector mirrorSelector, Location customLocation, Transport customTransport, File cacheDir) throws ManipulationException {
        this.mirrorSelector = mirrorSelector;
        this.init(session, customLocation, customTransport, cacheDir);
    }

    public MavenPomReader getPomReader() {
        return this.pomReader;
    }

    @Override
    public void init(ManipulationSession session) throws ManipulationException {
        this.init(session, null, null, null);
    }

    private void init(ManipulationSession session, Location customLocation, Transport customTransport, File cacheDir) throws ManipulationException {
        try {
            List<Location> custom = customLocation == null ? Collections.emptyList() : Collections.singletonList(customLocation);
            this.locationExpander = new MavenLocationExpander(custom, session.getRemoteRepositories(), session.getLocalRepository(), this.mirrorSelector, session.getSettings(), session.getActiveProfiles());
        }
        catch (MalformedURLException e) {
            throw new ManipulationException("Failed to setup Maven-specific LocationExpander: %s", (Throwable)e, e.getMessage());
        }
        this.xml = new XMLInfrastructure();
        this.xpaths = new XPathManager();
        TransportManagerImpl transports = customTransport != null ? new TransportManagerImpl(customTransport) : new TransportManagerImpl(new HttpClientTransport(new HttpImpl(new MemoryPasswordManager())), new FileTransport(), new ZipJarTransport());
        if (cacheDir == null) {
            cacheDir = new File(session.getTargetDir(), "manipulator-cache");
        }
        NoOpFileEventManager fileEvents = new NoOpFileEventManager();
        FileCacheProvider cache = new FileCacheProvider(cacheDir, (PathGenerator)new HashedLocationPathGenerator(), (FileEventManager)fileEvents, (TransferDecorator)new NoOpTransferDecorator());
        MemoryNotFoundCache nfc = new MemoryNotFoundCache();
        ExecutorService executor = Executors.newCachedThreadPool();
        TransferManagerImpl transfers = new TransferManagerImpl(transports, cache, nfc, fileEvents, new DownloadHandler(nfc, executor), new UploadHandler(nfc, executor), new ListingHandler(nfc), new ExistenceHandler(nfc), executor);
        StandardTypeMapper types = new StandardTypeMapper();
        ArtifactMetadataManagerImpl metadataManager = new ArtifactMetadataManagerImpl(transfers, this.locationExpander);
        VersionResolverImpl versionResolver = new VersionResolverImpl(new MavenMetadataReader(this.xml, this.locationExpander, metadataManager, this.xpaths));
        this.artifactManager = new ArtifactManagerImpl(transfers, this.locationExpander, types, versionResolver);
        StandardMaven304PluginDefaults pluginDefaults = new StandardMaven304PluginDefaults();
        StandardMavenPluginImplications pluginImplications = new StandardMavenPluginImplications(this.xml);
        this.pomReader = new MavenPomReader(this.xml, this.locationExpander, this.artifactManager, this.xpaths, pluginDefaults, pluginImplications);
        this.metadataReader = new MavenMetadataReader(this.xml, this.locationExpander, metadataManager, this.xpaths);
    }

    public XMLInfrastructure getXml() {
        return this.xml;
    }

    public MavenMetadataReader getMetadataReader() {
        return this.metadataReader;
    }

    public ArtifactManager getArtifactManager() {
        return this.artifactManager;
    }

    public XPathManager getXPath() {
        return this.xpaths;
    }
}

