/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.resolver;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.repository.MirrorSelector;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Settings;
import org.commonjava.maven.atlas.ident.util.JoinString;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Resource;
import org.commonjava.maven.galley.model.SimpleLocation;
import org.commonjava.maven.galley.model.VirtualResource;
import org.commonjava.maven.galley.spi.transport.LocationExpander;
import org.commonjava.maven.galley.transport.htcli.model.SimpleHttpLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenLocationExpander
implements LocationExpander {
    public static final Location EXPANSION_TARGET = new SimpleLocation("maven:repositories");
    private final List<Location> locations;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public MavenLocationExpander(List<Location> customLocations, List<ArtifactRepository> artifactRepositories, ArtifactRepository localRepository, MirrorSelector mirrorSelector, Settings settings, List<String> activeProfiles) throws MalformedURLException {
        LinkedHashSet<Location> locs = new LinkedHashSet<Location>();
        if (localRepository != null) {
            locs.add(new SimpleLocation(localRepository.getId(), new File(localRepository.getBasedir()).toURI().toString()));
        }
        if (customLocations != null) {
            locs.addAll(customLocations);
        }
        this.addSettingsProfileRepositoriesTo(locs, settings, activeProfiles, mirrorSelector);
        this.addRequestRepositoriesTo(locs, artifactRepositories, settings, mirrorSelector);
        this.logger.debug("Configured to use Maven locations:\n  {}", (Object)new JoinString("\n  ", locs));
        this.locations = new ArrayList<Location>(locs);
    }

    private void addRequestRepositoriesTo(Set<Location> locs, List<ArtifactRepository> artifactRepositories, Settings settings, MirrorSelector mirrorSelector) throws MalformedURLException {
        if (artifactRepositories != null) {
            for (ArtifactRepository repo : artifactRepositories) {
                String id = repo.getId();
                String url = repo.getUrl();
                if (url.startsWith("file:")) {
                    locs.add(new SimpleLocation(id, url));
                    continue;
                }
                List<Mirror> mirrors = settings.getMirrors();
                if (mirrors != null) {
                    Mirror mirror;
                    Mirror mirror2 = mirror = mirrorSelector == null ? null : mirrorSelector.getMirror(repo, mirrors);
                    if (mirror != null) {
                        id = mirror.getId();
                        url = mirror.getUrl();
                    }
                }
                ArtifactRepositoryPolicy releases = repo.getReleases();
                ArtifactRepositoryPolicy snapshots = repo.getSnapshots();
                SimpleHttpLocation addition = new SimpleHttpLocation(id, url, snapshots == null ? false : snapshots.isEnabled(), releases == null ? true : releases.isEnabled(), true, false, null);
                addition.setAttribute("connection-timeout", 60);
                locs.add(addition);
            }
        }
    }

    private void addSettingsProfileRepositoriesTo(Set<Location> locs, Settings settings, List<String> activeProfiles, MirrorSelector mirrorSelector) throws MalformedURLException {
        Map<String, Profile> profiles;
        if (settings != null && (profiles = settings.getProfilesAsMap()) != null && activeProfiles != null && !activeProfiles.isEmpty()) {
            LinkedHashSet<String> active = new LinkedHashSet<String>(activeProfiles);
            List<String> settingsActiveProfiles = settings.getActiveProfiles();
            if (settingsActiveProfiles != null && !settingsActiveProfiles.isEmpty()) {
                active.addAll(settingsActiveProfiles);
            }
            for (String profileId : active) {
                List<Repository> repositories;
                Profile profile = profiles.get(profileId);
                if (profile == null || (repositories = profile.getRepositories()) == null) continue;
                List<Mirror> mirrors = settings.getMirrors();
                DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
                for (Repository repo : repositories) {
                    Mirror mirror;
                    String id = repo.getId();
                    String url = repo.getUrl();
                    if (mirrors == null) continue;
                    ArtifactRepositoryPolicy snapshots = this.convertPolicy(repo.getSnapshots());
                    ArtifactRepositoryPolicy releases = this.convertPolicy(repo.getReleases());
                    MavenArtifactRepository arepo = new MavenArtifactRepository(id, url, layout, snapshots, releases);
                    Mirror mirror2 = mirror = mirrorSelector == null ? null : mirrorSelector.getMirror(arepo, mirrors);
                    if (mirror != null) {
                        id = mirror.getId();
                        url = mirror.getUrl();
                    }
                    SimpleHttpLocation addition = new SimpleHttpLocation(id, url, snapshots == null ? false : snapshots.isEnabled(), releases == null ? true : releases.isEnabled(), true, false, null);
                    addition.setAttribute("connection-timeout", 60);
                    locs.add(addition);
                }
            }
        }
    }

    private ArtifactRepositoryPolicy convertPolicy(RepositoryPolicy policy) {
        if (policy == null) {
            return new ArtifactRepositoryPolicy();
        }
        return new ArtifactRepositoryPolicy(policy.isEnabled(), policy.getUpdatePolicy(), policy.getChecksumPolicy());
    }

    @Override
    public List<Location> expand(Location ... locations) throws TransferException {
        ArrayList<Location> result = new ArrayList<Location>();
        for (Location loc : locations) {
            this.expandSingle(loc, result);
        }
        this.logger.debug("Expanded to:\n {}", (Object)new JoinString("\n  ", result));
        return result;
    }

    @Override
    public <T extends Location> List<Location> expand(Collection<T> locations) throws TransferException {
        ArrayList<Location> result = new ArrayList<Location>();
        for (Location loc : locations) {
            this.expandSingle(loc, result);
        }
        this.logger.debug("Expanded to:\n {}", (Object)new JoinString("\n  ", result));
        return result;
    }

    @Override
    public VirtualResource expand(Resource resource) throws TransferException {
        ArrayList<ConcreteResource> result = new ArrayList<ConcreteResource>();
        if (resource instanceof ConcreteResource) {
            this.expandSingle((ConcreteResource)resource, result);
        } else {
            for (ConcreteResource cr : ((VirtualResource)resource).toConcreteResources()) {
                this.expandSingle(cr, result);
            }
        }
        this.logger.debug("Expanded to:\n {}", (Object)new JoinString("\n  ", result));
        return new VirtualResource(result);
    }

    private void expandSingle(ConcreteResource cr, List<ConcreteResource> result) {
        Location loc = cr.getLocation();
        ArrayList<Location> expanded = new ArrayList<Location>();
        this.expandSingle(loc, expanded);
        String path = cr.getPath();
        for (Location location : expanded) {
            result.add(new ConcreteResource(location, path));
        }
    }

    private void expandSingle(Location loc, List<Location> result) {
        this.logger.debug("Expanding: {}", (Object)loc);
        if (EXPANSION_TARGET.equals(loc)) {
            this.logger.debug("Expanding...");
            result.addAll(this.locations);
        } else {
            this.logger.debug("No expansion available.");
            result.add(loc);
        }
    }

    static {
        EXPANSION_TARGET.setAttribute("connection-timeout", 60);
    }
}

