/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.state;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.manip.state.State;
import org.commonjava.maven.ext.manip.util.IdUtils;

public class DependencyState
implements State {
    public static final String DEPENDENCY_EXCLUSION_PREFIX = "dependencyExclusion.";
    public static final String STRICT_DEPENDENCIES = "strictAlignment";
    public static final String STRICT_VIOLATION_FAILS = "strictViolationFails";
    public static final String DEPENDENCY_MANAGEMENT_POM_PROPERTY = "dependencyManagement";
    private final List<ProjectVersionRef> depMgmt;
    private final boolean overrideTransitive;
    private final boolean overrideDependencies;
    private final boolean strict;
    private final boolean failOnStrictViolation;
    private final HashMap<String, String> versionPropertyUpdateMap = new HashMap();

    public DependencyState(Properties userProps) {
        this.overrideTransitive = Boolean.valueOf(userProps.getProperty("overrideTransitive", "true"));
        this.overrideDependencies = Boolean.valueOf(userProps.getProperty("overrideDependencies", "true"));
        this.strict = Boolean.valueOf(userProps.getProperty(STRICT_DEPENDENCIES, "false"));
        this.failOnStrictViolation = Boolean.valueOf(userProps.getProperty(STRICT_VIOLATION_FAILS, "false"));
        this.depMgmt = IdUtils.parseGAVs(userProps.getProperty(DEPENDENCY_MANAGEMENT_POM_PROPERTY));
    }

    @Override
    public boolean isEnabled() {
        return this.depMgmt != null && !this.depMgmt.isEmpty();
    }

    public boolean getOverrideTransitive() {
        return this.overrideTransitive;
    }

    public boolean getOverrideDependencies() {
        return this.overrideDependencies;
    }

    public List<ProjectVersionRef> getRemoteDepMgmt() {
        return this.depMgmt;
    }

    public boolean getStrict() {
        return this.strict;
    }

    public HashMap<String, String> getVersionPropertyUpdateMap() {
        return this.versionPropertyUpdateMap;
    }

    public boolean getFailOnStrictViolation() {
        return this.failOnStrictViolation;
    }

    public static enum VersionPropertyFormat {
        VG,
        VGA,
        NONE;

    }
}

