/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.state;

import java.util.Properties;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.manip.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileInjectionState
implements State {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String PROFILE_INJECTION_PROPERTY = "profileInjection";
    private final ProjectVersionRef profileMgmt;

    public ProfileInjectionState(Properties userProps) {
        String gav = userProps.getProperty(PROFILE_INJECTION_PROPERTY);
        ProjectVersionRef ref = null;
        if (gav != null) {
            try {
                ref = ProjectVersionRef.parse(gav);
            }
            catch (InvalidRefException e) {
                this.logger.error("Skipping profile injection! Got invalid profileInjection GAV: {}", (Object)gav);
                throw e;
            }
        }
        this.profileMgmt = ref;
    }

    @Override
    public boolean isEnabled() {
        return this.profileMgmt != null;
    }

    public ProjectVersionRef getRemoteProfileInjectionMgmt() {
        return this.profileMgmt;
    }
}

