/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.state;

import java.util.Properties;
import org.commonjava.maven.ext.manip.state.State;

public class ProjectSourcesInjectingState
implements State {
    public static final String PROJECT_SOURCES_SKIP_PROPERTY = "project.src.skip";
    public static final String BMMP_SKIP_PROPERTY = "project.meta.skip";
    public static final String PROJECT_SOURCES_PLUGIN_VERSION_PROPERTY = "project.src.version";
    public static final String DEFAULT_PROJECT_SOURCES_PLUGIN_VERSION = "0.3";
    public static final String BMMP_VERSION_PROPERTY = "project.meta.version";
    public static final String DEFAULT_BMMP_VERSION = "1.5.2";
    private final boolean projectsourcesEnabled;
    private final boolean metadataEnabled;
    private final String projectSrcPluginVersion;
    private final String bmmpVersion;

    public ProjectSourcesInjectingState(Properties userProperties) {
        this.projectsourcesEnabled = !Boolean.parseBoolean(userProperties.getProperty(PROJECT_SOURCES_SKIP_PROPERTY, "false"));
        this.metadataEnabled = !Boolean.parseBoolean(userProperties.getProperty(BMMP_SKIP_PROPERTY, "false"));
        this.projectSrcPluginVersion = userProperties.getProperty(PROJECT_SOURCES_PLUGIN_VERSION_PROPERTY, DEFAULT_PROJECT_SOURCES_PLUGIN_VERSION);
        this.bmmpVersion = userProperties.getProperty(BMMP_VERSION_PROPERTY, DEFAULT_BMMP_VERSION);
    }

    @Override
    public boolean isEnabled() {
        return this.isBuildMetadataPluginEnabled() || this.isProjectSourcesPluginEnabled();
    }

    public boolean isProjectSourcesPluginEnabled() {
        return this.projectsourcesEnabled;
    }

    public boolean isBuildMetadataPluginEnabled() {
        return this.metadataEnabled;
    }

    public String getProjectSourcesPluginVersion() {
        return this.projectSrcPluginVersion;
    }

    public String getBuildMetadataPluginVersion() {
        return this.bmmpVersion;
    }

    static {
        State.activeByDefault.add(ProjectSourcesInjectingState.class);
    }
}

