/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.state;

import java.util.Map;
import java.util.Properties;
import org.commonjava.maven.ext.manip.state.State;

public class VersioningState
implements State {
    public static final String VERSION_SUFFIX_SYSPROP = "version.suffix";
    public static final String INCREMENT_SERIAL_SUFFIX_SYSPROP = "version.incremental.suffix";
    public static final String VERSION_SUFFIX_SNAPSHOT_SYSPROP = "version.suffix.snapshot";
    public static final String VERSION_OSGI_SYSPROP = "version.osgi";
    public static final String VERSION_OVERRIDE_SYSPROP = "version.override";
    private Map<String, String> versioningChanges;
    private final String suffix;
    private final String incrementSerialSuffix;
    private final boolean preserveSnapshot;
    private final boolean osgi;
    private final String override;

    public VersioningState(Properties userProps) {
        this.suffix = userProps.getProperty(VERSION_SUFFIX_SYSPROP);
        this.incrementSerialSuffix = userProps.getProperty(INCREMENT_SERIAL_SUFFIX_SYSPROP);
        this.preserveSnapshot = Boolean.parseBoolean(userProps.getProperty(VERSION_SUFFIX_SNAPSHOT_SYSPROP));
        this.osgi = Boolean.parseBoolean(userProps.getProperty(VERSION_OSGI_SYSPROP, "true"));
        this.override = userProps.getProperty(VERSION_OVERRIDE_SYSPROP);
    }

    public void setVersioningChanges(Map<String, String> versioningChanges) {
        this.versioningChanges = versioningChanges;
    }

    public Map<String, String> getVersioningChanges() {
        return this.versioningChanges;
    }

    public String getIncrementalSerialSuffix() {
        return this.incrementSerialSuffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean preserveSnapshot() {
        return this.preserveSnapshot;
    }

    public String getOverride() {
        return this.override;
    }

    public boolean osgi() {
        return this.osgi;
    }

    @Override
    public boolean isEnabled() {
        return this.incrementSerialSuffix != null || this.suffix != null || this.override != null;
    }
}

