/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesUtils {
    private PropertiesUtils() {
    }

    public static Map<String, String> getPropertiesByPrefix(Properties properties, String prefix) {
        Logger logger = LoggerFactory.getLogger(PropertiesUtils.class);
        HashMap<String, String> matchedProperties = new HashMap<String, String>();
        int prefixLength = prefix.length();
        for (String propertyName : properties.stringPropertyNames()) {
            if (!propertyName.startsWith(prefix)) continue;
            String trimmedPropertyName = propertyName.substring(prefixLength);
            String value = properties.getProperty(propertyName);
            if (value.equals("true")) {
                logger.warn("Work around Brew/Maven bug - removing erroneous 'true' value for {}.", (Object)trimmedPropertyName);
                value = "";
            }
            matchedProperties.put(trimmedPropertyName, value);
        }
        return matchedProperties;
    }
}

