/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.commonjava.maven.galley.TransferManager;
import org.commonjava.maven.galley.spi.auth.PasswordManager;
import org.commonjava.maven.galley.spi.cache.CacheProvider;
import org.commonjava.maven.galley.spi.event.FileEventManager;
import org.commonjava.maven.galley.spi.io.TransferDecorator;
import org.commonjava.maven.galley.spi.nfc.NotFoundCache;
import org.commonjava.maven.galley.spi.transport.LocationExpander;
import org.commonjava.maven.galley.spi.transport.LocationResolver;
import org.commonjava.maven.galley.spi.transport.Transport;
import org.commonjava.maven.galley.spi.transport.TransportManager;

public class GalleyCore {
    @Inject
    private LocationExpander locationExpander;
    @Inject
    private LocationResolver locationResolver;
    @Inject
    private TransferDecorator decorator;
    @Inject
    private FileEventManager events;
    @Inject
    private CacheProvider cache;
    @Inject
    private NotFoundCache nfc;
    @Inject
    private TransportManager transportManager;
    @Inject
    private TransferManager transferManager;
    @Inject
    private Instance<Transport> injectedTransports;
    private List<Transport> transports;
    @Inject
    private ExecutorService handlerExecutor;
    @Inject
    private ExecutorService batchExecutor;
    @Inject
    private PasswordManager passwordManager;

    protected GalleyCore() {
    }

    public GalleyCore(LocationExpander locationExpander, LocationResolver locationResolver, TransferDecorator decorator, FileEventManager events, CacheProvider cache, NotFoundCache nfc, TransportManager transportManager, TransferManager transferManager, List<Transport> transports, ExecutorService handlerExecutor, ExecutorService batchExecutor, PasswordManager passwordManager) {
        this.locationExpander = locationExpander;
        this.locationResolver = locationResolver;
        this.decorator = decorator;
        this.events = events;
        this.cache = cache;
        this.nfc = nfc;
        this.transportManager = transportManager;
        this.transferManager = transferManager;
        this.transports = transports;
        this.handlerExecutor = handlerExecutor;
        this.batchExecutor = batchExecutor;
        this.passwordManager = passwordManager;
    }

    @PostConstruct
    public void initInjections() {
        if (this.transports == null && this.injectedTransports != null) {
            this.transports = new ArrayList<Transport>();
            for (Transport transport : this.injectedTransports) {
                this.transports.add(transport);
            }
        }
    }

    public PasswordManager getPasswordManager() {
        return this.passwordManager;
    }

    public LocationExpander getLocationExpander() {
        return this.locationExpander;
    }

    public LocationResolver getLocationResolver() {
        return this.locationResolver;
    }

    public TransferDecorator getTransferDecorator() {
        return this.decorator;
    }

    public FileEventManager getFileEvents() {
        return this.events;
    }

    public CacheProvider getCache() {
        return this.cache;
    }

    public NotFoundCache getNfc() {
        return this.nfc;
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    public TransferManager getTransferManager() {
        return this.transferManager;
    }

    public List<Transport> getEnabledTransports() {
        return this.transports;
    }

    public ExecutorService getHandlerExecutor() {
        return this.handlerExecutor;
    }

    public ExecutorService getBatchExecutor() {
        return this.batchExecutor;
    }
}

