/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.commonjava.maven.galley.cache.FileCacheProviderConfig;
import org.commonjava.maven.galley.cache.SimpleLockingSupport;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.spi.cache.CacheProvider;
import org.commonjava.maven.galley.spi.event.FileEventManager;
import org.commonjava.maven.galley.spi.io.PathGenerator;
import org.commonjava.maven.galley.spi.io.TransferDecorator;
import org.commonjava.maven.galley.util.AtomicFileOutputStreamWrapper;
import org.commonjava.maven.galley.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="file-galley-cache")
@Alternative
public class FileCacheProvider
implements CacheProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<ConcreteResource, Transfer> transferCache = new ConcurrentHashMap<ConcreteResource, Transfer>(10000);
    @Inject
    private FileCacheProviderConfig config;
    @Inject
    private PathGenerator pathGenerator;
    @Inject
    private FileEventManager fileEventManager;
    @Inject
    private TransferDecorator transferDecorator;
    private final SimpleLockingSupport lockingSupport = new SimpleLockingSupport();

    protected FileCacheProvider() {
    }

    public FileCacheProvider(File cacheBasedir, PathGenerator pathGenerator, FileEventManager fileEventManager, TransferDecorator transferDecorator, boolean aliasLinking) {
        this.pathGenerator = pathGenerator;
        this.fileEventManager = fileEventManager;
        this.transferDecorator = transferDecorator;
        this.config = new FileCacheProviderConfig(cacheBasedir).withAliasLinking(aliasLinking);
    }

    public FileCacheProvider(FileCacheProviderConfig config, PathGenerator pathGenerator, FileEventManager fileEventManager, TransferDecorator transferDecorator) {
        this.config = config;
        this.pathGenerator = pathGenerator;
        this.fileEventManager = fileEventManager;
        this.transferDecorator = transferDecorator;
    }

    public FileCacheProvider(File cacheBasedir, PathGenerator pathGenerator, FileEventManager fileEventManager, TransferDecorator transferDecorator) {
        this(cacheBasedir, pathGenerator, fileEventManager, transferDecorator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getDetachedFile(ConcreteResource resource) {
        Transfer txfr;
        Transfer transfer = txfr = this.getTransfer(resource);
        synchronized (transfer) {
            int tos;
            long timeout;
            long lastModified;
            long current;
            String altDir = resource.getLocation().getAttribute("alt-storage-location", String.class);
            File f = altDir == null ? new File(this.getFilePath(resource)) : new File(altDir, resource.getPath());
            if (resource.isRoot() && !f.isDirectory()) {
                f.mkdirs();
            }
            int timeoutSeconds = resource.getLocation().getAttribute("cache-timeout", Integer.class, 86400);
            if (!resource.isRoot() && f.exists() && !f.isDirectory() && timeoutSeconds > 0 && (current = System.currentTimeMillis()) - (lastModified = f.lastModified()) > (timeout = TimeUnit.MILLISECONDS.convert(tos = timeoutSeconds < 3600 ? 3600 : timeoutSeconds, TimeUnit.SECONDS))) {
                File mved = new File(f.getPath() + ".to-delete");
                f.renameTo(mved);
                try {
                    this.logger.info("Deleting cached file: {} (moved to: {})\n  due to timeout after: {}\n  elapsed: {}\n  original timeout in seconds: {}", f, mved, timeout, current - lastModified, tos);
                    if (mved.exists()) {
                        FileUtils.forceDelete(mved);
                    }
                }
                catch (IOException e) {
                    this.logger.error(String.format("Failed to delete: %s.", f), e);
                }
            }
            return f;
        }
    }

    @Override
    public boolean isDirectory(ConcreteResource resource) {
        File f = this.getDetachedFile(resource);
        return f.isDirectory();
    }

    @Override
    public boolean isFile(ConcreteResource resource) {
        File f = this.getDetachedFile(resource);
        return f.isFile();
    }

    @Override
    public InputStream openInputStream(ConcreteResource resource) throws IOException {
        return new FileInputStream(this.getDetachedFile(resource));
    }

    @Override
    public OutputStream openOutputStream(ConcreteResource resource) throws IOException {
        File targetFile = this.getDetachedFile(resource);
        File dir = targetFile.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new IOException("Cannot create directory: " + dir);
        }
        File downloadFile = new File(targetFile.getPath() + ".to-write");
        FileOutputStream stream = new FileOutputStream(downloadFile);
        return new AtomicFileOutputStreamWrapper(targetFile, downloadFile, stream);
    }

    @Override
    public boolean exists(ConcreteResource resource) {
        File f = this.getDetachedFile(resource);
        return f.exists();
    }

    @Override
    public void copy(ConcreteResource from, ConcreteResource to) throws IOException {
        FileUtils.copyFile(this.getDetachedFile(from), this.getDetachedFile(to));
    }

    @Override
    public boolean delete(ConcreteResource resource) throws IOException {
        return this.getDetachedFile(resource).delete();
    }

    @Override
    public String[] list(ConcreteResource resource) {
        String[] listing = this.getDetachedFile(resource).list();
        if (listing == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(listing));
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String fname = (String)it.next();
            if (fname.charAt(0) == '.') {
                it.remove();
                continue;
            }
            for (String suffix : HIDDEN_SUFFIXES) {
                if (!fname.endsWith(suffix)) continue;
                it.remove();
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void mkdirs(ConcreteResource resource) throws IOException {
        this.getDetachedFile(resource).mkdirs();
    }

    @Override
    public void createFile(ConcreteResource resource) throws IOException {
        this.getDetachedFile(resource).createNewFile();
    }

    @Override
    public void createAlias(ConcreteResource from, ConcreteResource to) throws IOException {
        Location fromKey = from.getLocation();
        Location toKey = to.getLocation();
        String fromPath = from.getPath();
        String toPath = to.getPath();
        if (fromKey != null && toKey != null && !fromKey.equals(toKey) && fromPath != null && toPath != null && !fromPath.equals(toPath)) {
            if (this.config.isAliasLinking()) {
                File fromFile = this.getDetachedFile(from);
                File toFile = this.getDetachedFile(to);
                FileUtils.copyFile(fromFile, toFile);
            } else {
                this.copy(from, to);
            }
        }
    }

    @Override
    public String getFilePath(ConcreteResource resource) {
        return PathUtils.normalize(this.config.getCacheBasedir().getPath(), this.pathGenerator.getFilePath(resource)).toString();
    }

    @Override
    public synchronized Transfer getTransfer(ConcreteResource resource) {
        Transfer t = this.transferCache.get(resource);
        if (t == null) {
            t = new Transfer(resource, this, this.fileEventManager, this.transferDecorator);
            this.transferCache.put(resource, t);
        }
        return t;
    }

    @Override
    public void clearTransferCache() {
        this.transferCache.clear();
    }

    @Override
    public long length(ConcreteResource resource) {
        return this.getDetachedFile(resource).length();
    }

    @Override
    public long lastModified(ConcreteResource resource) {
        return this.getDetachedFile(resource).lastModified();
    }

    @Override
    public boolean isReadLocked(ConcreteResource resource) {
        return this.lockingSupport.isLocked(resource);
    }

    @Override
    public boolean isWriteLocked(ConcreteResource resource) {
        return this.lockingSupport.isLocked(resource);
    }

    @Override
    public void unlockRead(ConcreteResource resource) {
        this.lockingSupport.unlock(resource);
    }

    @Override
    public void unlockWrite(ConcreteResource resource) {
        this.lockingSupport.unlock(resource);
    }

    @Override
    public void lockRead(ConcreteResource resource) {
        this.lockingSupport.lock(resource);
    }

    @Override
    public void lockWrite(ConcreteResource resource) {
        this.lockingSupport.lock(resource);
    }

    @Override
    public void waitForWriteUnlock(ConcreteResource resource) {
        this.lockingSupport.waitForUnlock(resource);
    }

    @Override
    public void waitForReadUnlock(ConcreteResource resource) {
        this.lockingSupport.waitForUnlock(resource);
    }

    @Override
    public void cleanupCurrentThread() {
        this.lockingSupport.cleanupCurrentThread();
    }

    @Override
    public void startReporting() {
        this.lockingSupport.startReporting();
    }

    @Override
    public void stopReporting() {
        this.lockingSupport.stopReporting();
    }
}

