/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.filearc.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.spi.transport.DownloadJob;

public class FileDownload
implements DownloadJob {
    private TransferException error;
    private final Transfer txfr;
    private final File src;
    private final EventMetadata eventMetadata;

    public FileDownload(Transfer txfr, File src, EventMetadata eventMetadata) {
        this.txfr = txfr;
        this.src = src;
        this.eventMetadata = eventMetadata;
    }

    @Override
    public TransferException getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DownloadJob call() {
        FileDownload fileDownload;
        FileInputStream in = null;
        OutputStream out = null;
        try {
            if (this.src.exists() && !this.src.isDirectory()) {
                in = new FileInputStream(this.src);
                out = this.txfr.openOutputStream(TransferOperation.DOWNLOAD, true, this.eventMetadata);
                IOUtils.copy((InputStream)in, out);
            }
            fileDownload = this;
        }
        catch (IOException e) {
            try {
                this.error = new TransferException("Failed to copy from: %s to: %s. Reason: %s", (Throwable)e, this.src, this.txfr, e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            return this;
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(out);
        return fileDownload;
    }

    @Override
    public Transfer getTransfer() {
        return this.txfr;
    }
}

