/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.filearc.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.ListingResult;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.spi.transport.ListingJob;

public class FileListing
implements ListingJob {
    private TransferException error;
    private final File src;
    private final ConcreteResource resource;
    private final Transfer target;

    public FileListing(ConcreteResource resource, File src, Transfer target) {
        this.resource = resource;
        this.src = src;
        this.target = target;
    }

    @Override
    public TransferException getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListingResult call() {
        if (this.src.isDirectory()) {
            ListingResult listingResult;
            Object[] raw = this.src.list();
            OutputStream stream = null;
            try {
                stream = this.target.openOutputStream(TransferOperation.DOWNLOAD);
                stream.write(StringUtils.join(raw, "\n").getBytes("UTF-8"));
                listingResult = new ListingResult(this.resource, (String[])raw);
            }
            catch (IOException e) {
                try {
                    this.error = new TransferException("Failed to write listing to: %s. Reason: %s", (Throwable)e, this.target, e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
                IOUtils.closeQuietly(stream);
            }
            IOUtils.closeQuietly(stream);
            return listingResult;
        }
        return null;
    }
}

