/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.filearc.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.spi.transport.PublishJob;

public class FilePublish
implements PublishJob {
    private final File dest;
    private final InputStream stream;
    private TransferException error;
    private boolean success;

    public FilePublish(File dest, InputStream stream) {
        this.dest = dest;
        this.stream = stream;
    }

    @Override
    public TransferException getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilePublish call() {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.dest);
            IOUtils.copy(this.stream, (OutputStream)out);
            this.success = true;
        }
        catch (IOException e) {
            this.error = new TransferException("Failed to write to: %s. Reason: %s", (Throwable)e, this.dest, e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(this.stream);
            IOUtils.closeQuietly(out);
        }
        return this;
    }

    @Override
    public boolean isSuccessful() {
        return this.success;
    }
}

