/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.filearc.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.filearc.internal.AbstractZipOperation;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.ListingResult;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.spi.transport.ListingJob;

public class ZipListing
extends AbstractZipOperation
implements ListingJob {
    private TransferException error;

    public ZipListing(ConcreteResource resource, Transfer target) {
        super(resource);
        this.transfer = target;
    }

    @Override
    public TransferException getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListingResult call() {
        File src = this.getZipFile();
        if (src.isDirectory()) {
            return null;
        }
        boolean isJar = this.isJarOperation();
        TreeSet<String> filenames = new TreeSet<String>();
        ZipFile zf = null;
        try {
            zf = isJar ? new JarFile(src) : new ZipFile(src);
            String path = this.getFullPath();
            int pathLen = path.length();
            for (ZipEntry zipEntry : Collections.list(zf.entries())) {
                String name = zipEntry.getName();
                if (!name.startsWith(path) || !(name = name.substring(pathLen)).startsWith("/") || name.length() <= 1 || (name = name.substring(1)).indexOf("/") >= 0) continue;
                filenames.add(name);
            }
        }
        catch (IOException e) {
            this.error = new TransferException("Failed to get listing for: %s to: %s. Reason: %s", (Throwable)e, this.resource, e.getMessage());
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException e) {}
            }
        }
        if (!filenames.isEmpty()) {
            ListingResult pathLen;
            OutputStream stream = null;
            try {
                stream = this.transfer.openOutputStream(TransferOperation.DOWNLOAD);
                stream.write(StringUtils.join(filenames, "\n").getBytes("UTF-8"));
                pathLen = new ListingResult(this.resource, filenames.toArray(new String[filenames.size()]));
            }
            catch (IOException e) {
                try {
                    this.error = new TransferException("Failed to write listing to: %s. Reason: %s", (Throwable)e, this.transfer, e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
                IOUtils.closeQuietly(stream);
            }
            IOUtils.closeQuietly(stream);
            return pathLen;
        }
        return null;
    }
}

