/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.commonjava.cdi.util.weft.ExecutorConfig;
import org.commonjava.maven.atlas.ident.util.JoinString;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.TransferManager;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.event.FileErrorEvent;
import org.commonjava.maven.galley.event.FileNotFoundEvent;
import org.commonjava.maven.galley.internal.xfer.BatchRetriever;
import org.commonjava.maven.galley.internal.xfer.DownloadHandler;
import org.commonjava.maven.galley.internal.xfer.ExistenceHandler;
import org.commonjava.maven.galley.internal.xfer.ListingHandler;
import org.commonjava.maven.galley.internal.xfer.UploadHandler;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.ListingResult;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Resource;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferBatch;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.model.VirtualResource;
import org.commonjava.maven.galley.spi.cache.CacheProvider;
import org.commonjava.maven.galley.spi.event.FileEventManager;
import org.commonjava.maven.galley.spi.nfc.NotFoundCache;
import org.commonjava.maven.galley.spi.transport.Transport;
import org.commonjava.maven.galley.spi.transport.TransportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferManagerImpl
implements TransferManager {
    private static final Set<String> BANNED_LISTING_NAMES = Collections.unmodifiableSet(new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(".listing.txt");
        }
    });
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private CacheProvider cacheProvider;
    @Inject
    private NotFoundCache nfc;
    @Inject
    private TransportManager transportManager;
    @Inject
    private FileEventManager fileEventManager;
    @Inject
    private DownloadHandler downloader;
    @Inject
    private UploadHandler uploader;
    @Inject
    private ListingHandler lister;
    @Inject
    private ExistenceHandler exister;
    @Inject
    @ExecutorConfig(threads=12, daemon=true, named="galley-batching", priority=8)
    private ExecutorService executor;

    protected TransferManagerImpl() {
    }

    public TransferManagerImpl(TransportManager transportManager, CacheProvider cacheProvider, NotFoundCache nfc, FileEventManager fileEventManager, DownloadHandler downloader, UploadHandler uploader, ListingHandler lister, ExistenceHandler exister, ExecutorService executor) {
        this.transportManager = transportManager;
        this.cacheProvider = cacheProvider;
        this.nfc = nfc;
        this.fileEventManager = fileEventManager;
        this.downloader = downloader;
        this.uploader = uploader;
        this.lister = lister;
        this.exister = exister;
        this.executor = executor;
    }

    @Override
    public boolean exists(ConcreteResource resource) throws TransferException {
        return this.exists(resource, false);
    }

    @Override
    public ConcreteResource findFirstExisting(VirtualResource virt) throws TransferException {
        for (ConcreteResource res : virt) {
            if (!this.exists(res, true)) continue;
            return res;
        }
        return null;
    }

    @Override
    public List<ConcreteResource> findAllExisting(VirtualResource virt) throws TransferException {
        ArrayList<ConcreteResource> results = new ArrayList<ConcreteResource>();
        for (ConcreteResource res : virt) {
            if (!this.exists(res, true)) continue;
            results.add(res);
        }
        return results;
    }

    private boolean exists(ConcreteResource resource, boolean suppressFailures) throws TransferException {
        Transfer cached = this.getCacheReference(resource);
        if (cached.exists()) {
            return true;
        }
        return this.exister.exists(resource, cached, this.getTimeoutSeconds(resource), this.getTransport(resource), suppressFailures);
    }

    @Override
    public List<ListingResult> listAll(VirtualResource virt) throws TransferException {
        ArrayList<ListingResult> results = new ArrayList<ListingResult>();
        for (ConcreteResource res : virt) {
            ListingResult result = this.doList(res, true);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    @Override
    public ListingResult list(ConcreteResource resource) throws TransferException {
        return this.doList(resource, false);
    }

    private ListingResult doList(ConcreteResource resource, boolean suppressFailures) throws TransferException {
        Transfer cachedListing = this.getCacheReference((ConcreteResource)resource.getChild(".listing.txt"));
        if (cachedListing.exists()) {
            InputStream stream = null;
            try {
                stream = cachedListing.openInputStream();
                List<String> filenames = IOUtils.readLines(stream, "UTF-8");
                ListingResult listingResult = new ListingResult(resource, filenames.toArray(new String[filenames.size()]));
                return listingResult;
            }
            catch (IOException e) {
                throw new TransferException("Failed to read listing from cached file: %s. Reason: %s", (Throwable)e, cachedListing, e.getMessage());
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }
        Transfer cached = this.getCacheReference(resource);
        ListingResult cacheResult = null;
        if (cached.exists()) {
            if (cached.isFile()) {
                throw new TransferException("Cannot list: {}. It does not appear to be a directory.", resource);
            }
            try {
                String[] fnames = cached.list();
                int idx = 0;
                for (String fname : fnames) {
                    if (BANNED_LISTING_NAMES.contains(fname)) continue;
                    ConcreteResource child = (ConcreteResource)resource.getChild(fname);
                    Transfer childRef = this.getCacheReference(child);
                    if (!childRef.isFile()) {
                        fnames[idx] = fname + "/";
                    }
                    ++idx;
                }
                cacheResult = new ListingResult(resource, fnames);
            }
            catch (IOException e) {
                throw new TransferException("Listing failed: {}. Reason: {}", (Throwable)e, resource, e.getMessage());
            }
        }
        if (!resource.getLocation().allowsDownloading()) {
            return cacheResult;
        }
        int timeoutSeconds = this.getTimeoutSeconds(resource);
        ListingResult remoteResult = this.lister.list(resource, cachedListing, timeoutSeconds, this.getTransport(resource), suppressFailures);
        ListingResult result = cacheResult != null && remoteResult != null ? cacheResult.mergeWith(remoteResult) : (cacheResult != null ? cacheResult : remoteResult);
        return result;
    }

    private Transport getTransport(ConcreteResource resource) throws TransferException {
        Transport transport = this.transportManager.getTransport(resource);
        if (transport == null && resource.getLocationUri() == null) {
            this.logger.debug("NFC: No remote URI. Marking as missing: {}", (Object)resource);
            this.nfc.addMissing(resource);
            return null;
        }
        return transport;
    }

    @Override
    public Transfer retrieveFirst(VirtualResource virt) throws TransferException {
        return this.retrieveFirst(virt, new EventMetadata());
    }

    @Override
    public Transfer retrieveFirst(VirtualResource virt, EventMetadata eventMetadata) throws TransferException {
        Transfer target = null;
        TransferException lastError = null;
        int tries = 0;
        for (ConcreteResource res : virt) {
            ++tries;
            if (res == null) continue;
            try {
                target = this.retrieve(res, true);
                lastError = null;
                if (target == null || !target.exists()) continue;
                return target;
            }
            catch (TransferException e) {
                this.logger.warn("Failed to retrieve: {}. {} more tries. (Reason: {})", res, virt.toConcreteResources().size() - tries, e.getMessage());
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        this.fileEventManager.fire(new FileNotFoundEvent(virt, eventMetadata));
        return null;
    }

    @Override
    public List<Transfer> retrieveAll(VirtualResource virt) throws TransferException {
        return this.retrieveAll(virt, new EventMetadata());
    }

    @Override
    public List<Transfer> retrieveAll(VirtualResource virt, EventMetadata eventMetadata) throws TransferException {
        TransferBatch batch = new TransferBatch(Collections.singleton(virt));
        batch = this.batchRetrieveAll(batch, eventMetadata);
        return new ArrayList<Transfer>(batch.getTransfers().values());
    }

    @Override
    public Transfer retrieve(ConcreteResource resource) throws TransferException {
        return this.retrieve(resource, false, new EventMetadata());
    }

    @Override
    public Transfer retrieve(ConcreteResource resource, boolean suppressFailures) throws TransferException {
        return this.retrieve(resource, suppressFailures, new EventMetadata());
    }

    @Override
    public Transfer retrieve(ConcreteResource resource, boolean suppressFailures, EventMetadata eventMetadata) throws TransferException {
        Transfer target = null;
        try {
            target = this.getCacheReference(resource);
            if (target.exists()) {
                this.logger.debug("Using cached copy of: {}", (Object)target);
                return target;
            }
            if (!resource.allowsDownloading()) {
                this.logger.debug("Download not allowed for: {}. Returning null transfer.", (Object)resource);
                return null;
            }
            Transfer retrieved = this.downloader.download(resource, target, this.getTimeoutSeconds(resource), this.getTransport(resource), suppressFailures, eventMetadata);
            if (retrieved != null && retrieved.exists() && !target.equals(retrieved)) {
                this.cacheProvider.createAlias(retrieved.getResource(), target.getResource());
            }
            if (target.exists()) {
                this.logger.debug("DOWNLOADED: {}", (Object)resource);
                return target;
            }
            this.logger.debug("NOT DOWNLOADED: {}", (Object)resource);
            return null;
        }
        catch (TransferException e) {
            this.fileEventManager.fire(new FileErrorEvent(target, e, eventMetadata));
            throw e;
        }
        catch (IOException e) {
            TransferException error = new TransferException("Failed to download: {}. Reason: {}", (Throwable)e, resource, e.getMessage());
            this.fileEventManager.fire(new FileErrorEvent(target, error, eventMetadata));
            throw error;
        }
    }

    @Override
    public Transfer store(ConcreteResource resource, InputStream stream) throws TransferException {
        return this.store(resource, stream, new EventMetadata());
    }

    @Override
    public Transfer store(ConcreteResource resource, InputStream stream, EventMetadata eventMetadata) throws TransferException {
        if (!resource.allowsStoring()) {
            throw new TransferException("Storing not allowed in: {}", resource);
        }
        Transfer target = this.getCacheReference(resource);
        this.logger.info("STORE {}", (Object)target.getResource());
        OutputStream out = null;
        try {
            out = target.openOutputStream(TransferOperation.UPLOAD, true, eventMetadata);
            IOUtils.copy(stream, out);
        }
        catch (IOException e) {
            try {
                throw new TransferException("Failed to store: {}. Reason: {}", (Throwable)e, resource, e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(out);
        return target;
    }

    @Override
    public Transfer getStoreRootDirectory(Location key) {
        return this.cacheProvider.getTransfer(new ConcreteResource(key, new String[0]));
    }

    @Override
    public Transfer getCacheReference(ConcreteResource resource) {
        return this.cacheProvider.getTransfer(resource);
    }

    @Override
    public boolean deleteAll(VirtualResource virt) throws TransferException {
        return this.deleteAll(virt, new EventMetadata());
    }

    @Override
    public boolean deleteAll(VirtualResource virt, EventMetadata eventMetadata) throws TransferException {
        boolean result = false;
        for (ConcreteResource res : virt) {
            result = this.delete(res, new EventMetadata()) || result;
        }
        return result;
    }

    @Override
    public boolean delete(ConcreteResource resource) throws TransferException {
        return this.delete(resource, new EventMetadata());
    }

    @Override
    public boolean delete(ConcreteResource resource, EventMetadata eventMetadata) throws TransferException {
        Transfer item = this.getCacheReference(resource);
        return this.doDelete(item, eventMetadata);
    }

    private Boolean doDelete(Transfer item, EventMetadata eventMetadata) throws TransferException {
        if (!item.exists()) {
            return false;
        }
        this.logger.info("DELETE {}", (Object)item.getResource());
        if (item.isDirectory()) {
            String[] listing;
            try {
                listing = item.list();
            }
            catch (IOException e) {
                throw new TransferException("Delete failed: {}. Reason: cannot list directory due to: {}", (Throwable)e, item, e.getMessage());
            }
            for (String sub : listing) {
                if (this.doDelete(item.getChild(sub), eventMetadata).booleanValue()) continue;
                return false;
            }
        } else {
            try {
                if (!item.delete(true, eventMetadata)) {
                    throw new TransferException("Failed to delete: {}.", item);
                }
            }
            catch (IOException e) {
                throw new TransferException("Failed to delete stored location: {}. Reason: {}", (Throwable)e, item, e.getMessage());
            }
        }
        return true;
    }

    @Override
    public boolean publish(ConcreteResource resource, InputStream stream, long length) throws TransferException {
        return this.publish(resource, stream, length, null);
    }

    @Override
    public boolean publish(ConcreteResource resource, InputStream stream, long length, String contentType) throws TransferException {
        return this.uploader.upload(resource, stream, length, contentType, this.getTimeoutSeconds(resource), this.getTransport(resource));
    }

    private int getTimeoutSeconds(ConcreteResource resource) {
        return resource.getLocation().getAttribute("connection-timeout", Integer.class, 30);
    }

    @Override
    public <T extends TransferBatch> T batchRetrieve(T batch) throws TransferException {
        return this.batchRetrieve(batch, new EventMetadata());
    }

    @Override
    public <T extends TransferBatch> T batchRetrieve(T batch, EventMetadata eventMetadata) throws TransferException {
        return this.doBatch(batch.getResources(), batch, true, eventMetadata);
    }

    @Override
    public <T extends TransferBatch> T batchRetrieveAll(T batch) throws TransferException {
        return this.batchRetrieveAll(batch, new EventMetadata());
    }

    @Override
    public <T extends TransferBatch> T batchRetrieveAll(T batch, EventMetadata eventMetadata) throws TransferException {
        Set<Resource> resources = batch.getResources();
        for (Resource resource : new HashSet<Resource>(resources)) {
            if (!(resource instanceof VirtualResource)) continue;
            resources.remove(resource);
            for (Resource r : (VirtualResource)resource) {
                resources.add(r);
            }
        }
        return this.doBatch(resources, batch, false, eventMetadata);
    }

    private <T extends TransferBatch> T doBatch(Set<Resource> resources, T batch, boolean suppressFailures, EventMetadata eventMetadata) throws TransferException {
        this.logger.info("Attempting to batch-retrieve {} resources:\n  {}", (Object)resources.size(), (Object)new JoinString("\n  ", resources));
        HashSet<BatchRetriever> retrievers = new HashSet<BatchRetriever>(resources.size());
        for (Resource resource : resources) {
            retrievers.add(new BatchRetriever(this, resource, suppressFailures, eventMetadata));
        }
        HashMap<ConcreteResource, TransferException> errors = new HashMap<ConcreteResource, TransferException>();
        HashMap<ConcreteResource, Transfer> transfers = new HashMap<ConcreteResource, Transfer>();
        int tries = 1;
        while (!retrievers.isEmpty()) {
            this.logger.debug("Starting attempt #{} to retrieve batch (batch size is currently: {})", (Object)tries, (Object)retrievers.size());
            CountDownLatch latch = new CountDownLatch(retrievers.size());
            for (BatchRetriever retriever : retrievers) {
                retriever.setLatch(latch);
                this.executor.execute(retriever);
            }
            while (latch.getCount() > 0L) {
                try {
                    latch.await(2L, TimeUnit.SECONDS);
                    if (latch.getCount() <= 0L) continue;
                    this.logger.info("Waiting for {} more transfers in batch to complete.", (Object)latch.getCount());
                    for (BatchRetriever retriever : retrievers) {
                        this.logger.info("Batch waiting on {}", (Object)retriever.getLastTry());
                    }
                }
                catch (InterruptedException e) {
                    this.logger.error(String.format("Failed to wait for batch retrieval attempts to complete: %s", e.getMessage()), e);
                    break;
                }
            }
            for (BatchRetriever retriever : new HashSet(retrievers)) {
                ConcreteResource resource = retriever.getLastTry();
                TransferException error = retriever.getError();
                if (error != null) {
                    errors.put(resource, error);
                    retrievers.remove(retriever);
                    this.logger.warn("ERROR: {}...{}", error, resource, error.getMessage());
                    continue;
                }
                Transfer transfer = retriever.getTransfer();
                if (transfer != null && transfer.exists()) {
                    transfers.put(resource, transfer);
                    retrievers.remove(retriever);
                    this.logger.debug("Completed: {}", (Object)resource);
                    continue;
                }
                if (retriever.hasMoreTries()) continue;
                this.logger.debug("Not completed, but out of tries: {}", (Object)resource);
                retrievers.remove(retriever);
            }
            ++tries;
        }
        batch.setErrors(errors);
        batch.setTransfers(transfers);
        return batch;
    }
}

