/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.internal.xfer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.cdi.util.weft.ExecutorConfig;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.spi.nfc.NotFoundCache;
import org.commonjava.maven.galley.spi.transport.DownloadJob;
import org.commonjava.maven.galley.spi.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DownloadHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private NotFoundCache nfc;
    private final Map<Transfer, Future<DownloadJob>> pending = new ConcurrentHashMap<Transfer, Future<DownloadJob>>();
    @Inject
    @ExecutorConfig(threads=12, daemon=true, named="galley-transfers", priority=8)
    private ExecutorService executor;

    public DownloadHandler() {
    }

    public DownloadHandler(NotFoundCache nfc, ExecutorService executor) {
        this.nfc = nfc;
        this.executor = executor;
    }

    public Transfer download(ConcreteResource resource, Transfer target, int timeoutSeconds, Transport transport, boolean suppressFailures, EventMetadata eventMetadata) throws TransferException {
        if (!resource.allowsDownloading()) {
            return null;
        }
        if (transport == null) {
            throw new TransferException("No transports available to handle: {} with location type: {}", resource, resource.getLocation().getClass().getSimpleName());
        }
        if (this.nfc.isMissing(resource)) {
            this.logger.debug("NFC: Already marked as missing: {}", (Object)resource);
            return null;
        }
        this.logger.debug("RETRIEVE {}", (Object)resource);
        Transfer result = this.joinOrStart(resource, target, timeoutSeconds, transport, suppressFailures, eventMetadata);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transfer joinOrStart(ConcreteResource resource, Transfer target, int timeoutSeconds, Transport transport, boolean suppressFailures, EventMetadata eventMetadata) throws TransferException {
        block19: {
            Object job;
            Future<DownloadJob> future;
            if (target.exists()) {
                return target;
            }
            Map<Transfer, Future<DownloadJob>> map = this.pending;
            synchronized (map) {
                future = this.pending.get(target);
                if (future == null) {
                    if (transport == null) {
                        return null;
                    }
                    job = transport.createDownloadJob(resource, target, timeoutSeconds, eventMetadata);
                    future = this.executor.submit(job);
                    this.pending.put(target, future);
                }
            }
            try {
                DownloadJob job2 = future.get(timeoutSeconds, TimeUnit.SECONDS);
                job = this.pending;
                synchronized (job) {
                    this.pending.remove(target);
                }
                Transfer downloaded = job2.getTransfer();
                if (job2.getError() != null) {
                    this.logger.debug("NFC: Download error. Marking as missing: {}\nError was: {}", job2.getError(), resource, job2.getError().getMessage());
                    this.nfc.addMissing(resource);
                    if (!suppressFailures) {
                        throw job2.getError();
                    }
                } else if (downloaded == null || !downloaded.exists()) {
                    this.logger.debug("NFC: Download did not complete. Marking as missing: {}", (Object)resource);
                    this.nfc.addMissing(resource);
                }
                return downloaded;
            }
            catch (InterruptedException e) {
                if (!suppressFailures) {
                    throw new TransferException("Download interrupted: {}", (Throwable)e, target);
                }
            }
            catch (ExecutionException e) {
                if (!suppressFailures) {
                    throw new TransferException("Download failed: {}", (Throwable)e, target);
                }
            }
            catch (TimeoutException e) {
                if (suppressFailures) break block19;
                throw new TransferException("Timeout on: {}", (Throwable)e, target);
            }
        }
        return null;
    }
}

