/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.internal.xfer;

import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.cdi.util.weft.ExecutorConfig;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Resource;
import org.commonjava.maven.galley.spi.nfc.NotFoundCache;
import org.commonjava.maven.galley.spi.transport.PublishJob;
import org.commonjava.maven.galley.spi.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class UploadHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private NotFoundCache nfc;
    private final Map<Resource, Future<PublishJob>> pending = new ConcurrentHashMap<Resource, Future<PublishJob>>();
    @Inject
    @ExecutorConfig(threads=12, daemon=true, named="galley-transfers", priority=8)
    private ExecutorService executor;

    public UploadHandler() {
    }

    public UploadHandler(NotFoundCache nfc, ExecutorService executor) {
        this.nfc = nfc;
        this.executor = executor;
    }

    public boolean upload(ConcreteResource resource, InputStream stream, long length, String contentType, int timeoutSeconds, Transport transport) throws TransferException {
        if (!resource.allowsPublishing()) {
            throw new TransferException("Publishing not allowed in: {}", resource);
        }
        if (transport == null) {
            throw new TransferException("No transports available to handle: {} with location type: {}", resource, resource.getLocation().getClass().getSimpleName());
        }
        this.logger.debug("PUBLISH {}", (Object)resource);
        return this.joinOrStart(resource, timeoutSeconds, stream, length, contentType, transport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean joinOrStart(ConcreteResource resource, int timeoutSeconds, InputStream stream, long length, String contentType, Transport transport) throws TransferException {
        Future<PublishJob> future;
        if (transport == null) {
            return false;
        }
        Map<Resource, Future<PublishJob>> map = this.pending;
        synchronized (map) {
            future = this.pending.get(resource);
            if (future == null) {
                PublishJob job = transport.createPublishJob(resource, stream, length, timeoutSeconds);
                future = this.executor.submit(job);
                this.pending.put(resource, future);
            }
        }
        try {
            PublishJob job = future.get(timeoutSeconds, TimeUnit.SECONDS);
            if (job.getError() != null) {
                throw job.getError();
            }
            this.nfc.clearMissing(resource);
            boolean bl = job.isSuccessful();
            return bl;
        }
        catch (InterruptedException e) {
            throw new TransferException("Interrupted publish: {}. Reason: {}", (Throwable)e, resource, e.getMessage());
        }
        catch (ExecutionException e) {
            throw new TransferException("Failed to publish: {}. Reason: {}", (Throwable)e, resource, e.getMessage());
        }
        catch (TimeoutException e) {
            throw new TransferException("Timed-out publish: {}. Reason: {}", (Throwable)e, resource, e.getMessage());
        }
        finally {
            this.pending.remove(resource);
        }
    }
}

