/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.commonjava.maven.galley.io.AbstractTransferDecorator;
import org.commonjava.maven.galley.io.checksum.AbstractChecksumGenerator;
import org.commonjava.maven.galley.io.checksum.AbstractChecksumGeneratorFactory;
import org.commonjava.maven.galley.io.checksum.ChecksummingOutputStream;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;

public final class ChecksummingTransferDecorator
extends AbstractTransferDecorator {
    private final Set<AbstractChecksumGeneratorFactory<?>> checksumFactories;
    private final Set<TransferOperation> ops;
    private final Set<String> ignoredFileEndings;

    public ChecksummingTransferDecorator(Set<TransferOperation> ops, Set<String> ignoredFileEndings, AbstractChecksumGeneratorFactory<?> ... checksumFactories) {
        this.ops = ops;
        this.ignoredFileEndings = ignoredFileEndings;
        this.checksumFactories = new HashSet(Arrays.asList(checksumFactories));
    }

    public ChecksummingTransferDecorator(Set<TransferOperation> ops, Set<String> ignoredFileEndings, Collection<AbstractChecksumGeneratorFactory<?>> checksumFactories) {
        this.ops = ops;
        this.ignoredFileEndings = ignoredFileEndings;
        this.checksumFactories = checksumFactories instanceof Set ? (Set<Object>)checksumFactories : new HashSet(checksumFactories);
    }

    @Override
    public OutputStream decorateWrite(OutputStream stream, Transfer transfer, TransferOperation op) throws IOException {
        if (this.ops.contains((Object)op)) {
            if (this.ignoredFileEndings == null || this.ignoredFileEndings.isEmpty()) {
                return new ChecksummingOutputStream(this.checksumFactories, stream, transfer);
            }
            String path = transfer.getPath();
            boolean ignored = false;
            for (String ending : this.ignoredFileEndings) {
                if (!path.endsWith(ending)) continue;
                ignored = true;
                break;
            }
            if (!ignored) {
                return new ChecksummingOutputStream(this.checksumFactories, stream, transfer);
            }
        }
        return stream;
    }

    @Override
    public InputStream decorateRead(InputStream stream, Transfer transfer) throws IOException {
        return stream;
    }

    @Override
    public void decorateDelete(Transfer transfer) throws IOException {
        boolean delete = false;
        if (this.ignoredFileEndings == null || this.ignoredFileEndings.isEmpty()) {
            delete = true;
        } else {
            String path = transfer.getPath();
            boolean ignored = false;
            for (String ending : this.ignoredFileEndings) {
                if (!path.endsWith(ending)) continue;
                ignored = true;
                break;
            }
            if (!ignored) {
                delete = true;
            }
        }
        if (delete) {
            for (AbstractChecksumGeneratorFactory<?> factory : this.checksumFactories) {
                Object generator = factory.createGenerator(transfer);
                ((AbstractChecksumGenerator)generator).delete();
            }
        }
    }
}

