/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.io.checksum;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChecksumGenerator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MessageDigest digester;
    private final String checksumExtension;
    private final Transfer checksumTransfer;

    protected AbstractChecksumGenerator(Transfer transfer, String checksumExtension, String type) throws IOException {
        this.checksumExtension = checksumExtension;
        try {
            this.digester = MessageDigest.getInstance(type);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Cannot get MessageDigest for checksum type: '" + type + "': " + e.getMessage(), e);
        }
        this.logger.debug("Getting checksum transfer for: {}", (Object)transfer);
        this.checksumTransfer = this.getChecksumFile(transfer);
        this.logger.debug("Locking checksum file: {}", (Object)this.checksumTransfer);
        this.checksumTransfer.lockWrite();
    }

    public final void update(byte[] data) {
        this.digester.update(data);
    }

    public final void update(byte data) {
        this.digester.update(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write() throws IOException {
        this.logger.info("Writing {} file: {}", (Object)this.checksumExtension, (Object)this.checksumTransfer);
        PrintStream out = null;
        OutputStream stream = null;
        try {
            stream = this.checksumTransfer.openOutputStream(TransferOperation.GENERATE);
            out = new PrintStream(stream);
            out.print(Hex.encodeHexString(this.digester.digest()));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly(out);
        IOUtils.closeQuietly(stream);
    }

    public final void delete() throws IOException {
        if (this.checksumTransfer.exists()) {
            this.checksumTransfer.delete();
            this.checksumTransfer.unlock();
        }
    }

    private final Transfer getChecksumFile(Transfer transfer) {
        return transfer.getSiblingMeta(this.checksumExtension);
    }
}

