/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.io.checksum;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.commonjava.maven.galley.io.checksum.AbstractChecksumGenerator;
import org.commonjava.maven.galley.io.checksum.AbstractChecksumGeneratorFactory;
import org.commonjava.maven.galley.model.Transfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChecksummingOutputStream
extends FilterOutputStream {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<AbstractChecksumGenerator> checksums;
    private final Transfer transfer;

    public ChecksummingOutputStream(Set<AbstractChecksumGeneratorFactory<?>> checksumFactories, OutputStream stream, Transfer transfer) throws IOException {
        super(stream);
        this.transfer = transfer;
        this.checksums = new HashSet<AbstractChecksumGenerator>();
        for (AbstractChecksumGeneratorFactory<?> factory : checksumFactories) {
            this.checksums.add((AbstractChecksumGenerator)factory.createGenerator(transfer));
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.logger.info("Wrote: {} in: {}. Now, writing checksums.", (Object)this.transfer.getPath(), (Object)this.transfer.getLocation());
        for (AbstractChecksumGenerator checksum : this.checksums) {
            checksum.write();
        }
    }

    @Override
    public void write(int data) throws IOException {
        super.write(data);
        for (AbstractChecksumGenerator checksum : this.checksums) {
            checksum.update((byte)data);
        }
    }
}

