/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.internal;

import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.TransferManager;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.maven.ArtifactMetadataManager;
import org.commonjava.maven.galley.maven.ArtifactRules;
import org.commonjava.maven.galley.maven.util.ArtifactPathUtils;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.VirtualResource;
import org.commonjava.maven.galley.spi.transport.LocationExpander;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactMetadataManagerImpl
implements ArtifactMetadataManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private TransferManager transferManager;
    @Inject
    private LocationExpander expander;

    protected ArtifactMetadataManagerImpl() {
    }

    public ArtifactMetadataManagerImpl(TransferManager transferManager, LocationExpander expander) {
        this.transferManager = transferManager;
        this.expander = expander;
    }

    @Override
    public boolean delete(Location location, ProjectRef ref) throws TransferException {
        return this.delete(location, ref, new EventMetadata());
    }

    @Override
    public boolean delete(Location location, ProjectRef ref, EventMetadata eventMetadata) throws TransferException {
        return this.delete(location, ref, null, eventMetadata);
    }

    @Override
    public boolean delete(Location location, ProjectRef ref, String filename) throws TransferException {
        return this.delete(location, ref, filename, new EventMetadata());
    }

    @Override
    public boolean delete(Location location, ProjectRef ref, String filename, EventMetadata eventMetadata) throws TransferException {
        String path = ArtifactPathUtils.formatMetadataPath(ref, filename);
        return this.transferManager.deleteAll(new VirtualResource(this.expander.expand(location), path), eventMetadata);
    }

    @Override
    public boolean delete(Location location, String groupId) throws TransferException {
        return this.delete(location, groupId, new EventMetadata());
    }

    @Override
    public boolean delete(Location location, String groupId, EventMetadata eventMetadata) throws TransferException {
        return this.delete(location, groupId, null, eventMetadata);
    }

    @Override
    public boolean delete(Location location, String groupId, String filename) throws TransferException {
        return this.delete(location, groupId, filename, new EventMetadata());
    }

    @Override
    public boolean delete(Location location, String groupId, String filename, EventMetadata eventMetadata) throws TransferException {
        String path = ArtifactPathUtils.formatMetadataPath(groupId, filename);
        return this.transferManager.deleteAll(new VirtualResource(this.expander.expand(location), path), eventMetadata);
    }

    @Override
    public boolean deleteAll(List<? extends Location> locations, String groupId) throws TransferException {
        return this.deleteAll(locations, groupId, new EventMetadata());
    }

    @Override
    public boolean deleteAll(List<? extends Location> locations, String groupId, EventMetadata eventMetadata) throws TransferException {
        return this.deleteAll(locations, groupId, null, eventMetadata);
    }

    @Override
    public boolean deleteAll(List<? extends Location> locations, String groupId, String filename) throws TransferException {
        return this.deleteAll(locations, groupId, filename, new EventMetadata());
    }

    @Override
    public boolean deleteAll(List<? extends Location> locations, String groupId, String filename, EventMetadata eventMetadata) throws TransferException {
        return this.transferManager.deleteAll(new VirtualResource(this.expander.expand(locations), ArtifactPathUtils.formatMetadataPath(groupId, filename)), eventMetadata);
    }

    @Override
    public boolean deleteAll(List<? extends Location> locations, ProjectRef ref) throws TransferException {
        return this.deleteAll(locations, ref, new EventMetadata());
    }

    @Override
    public boolean deleteAll(List<? extends Location> locations, ProjectRef ref, EventMetadata eventMetadata) throws TransferException {
        return this.deleteAll(locations, ref, null, eventMetadata);
    }

    @Override
    public boolean deleteAll(List<? extends Location> locations, ProjectRef ref, String filename) throws TransferException {
        return this.deleteAll(locations, ref, filename, new EventMetadata());
    }

    @Override
    public boolean deleteAll(List<? extends Location> locations, ProjectRef ref, String filename, EventMetadata eventMetadata) throws TransferException {
        return this.transferManager.deleteAll(new VirtualResource(this.expander.expand(locations), ArtifactPathUtils.formatMetadataPath(ref, filename)), eventMetadata);
    }

    @Override
    public Transfer retrieve(Location location, String groupId) throws TransferException {
        return this.retrieve(location, groupId, new EventMetadata());
    }

    @Override
    public Transfer retrieve(Location location, String groupId, EventMetadata eventMetadata) throws TransferException {
        return this.retrieve(location, groupId, null, eventMetadata);
    }

    @Override
    public Transfer retrieve(Location location, String groupId, String filename) throws TransferException {
        return this.retrieve(location, groupId, filename, new EventMetadata());
    }

    @Override
    public Transfer retrieve(Location location, String groupId, String filename, EventMetadata eventMetadata) throws TransferException {
        return this.transferManager.retrieveFirst(new VirtualResource(this.expander.expand(location), ArtifactPathUtils.formatMetadataPath(groupId, filename)), eventMetadata);
    }

    @Override
    public Transfer retrieve(Location location, ProjectRef ref) throws TransferException {
        return this.retrieve(location, ref, new EventMetadata());
    }

    @Override
    public Transfer retrieve(Location location, ProjectRef ref, EventMetadata eventMetadata) throws TransferException {
        return this.retrieve(location, ref, null, eventMetadata);
    }

    @Override
    public Transfer retrieve(Location location, ProjectRef ref, String filename) throws TransferException {
        return this.retrieve(location, ref, filename, new EventMetadata());
    }

    @Override
    public Transfer retrieve(Location location, ProjectRef ref, String filename, EventMetadata eventMetadata) throws TransferException {
        return this.transferManager.retrieveFirst(new VirtualResource(this.expander.expand(location), ArtifactPathUtils.formatMetadataPath(ref, filename)), eventMetadata);
    }

    @Override
    public List<Transfer> retrieveAll(List<? extends Location> locations, String groupId) throws TransferException {
        return this.retrieveAll(locations, groupId, new EventMetadata());
    }

    @Override
    public List<Transfer> retrieveAll(List<? extends Location> locations, String groupId, EventMetadata eventMetadata) throws TransferException {
        return this.retrieveAll(locations, groupId, null, eventMetadata);
    }

    @Override
    public List<Transfer> retrieveAll(List<? extends Location> locations, String groupId, String filename) throws TransferException {
        return this.retrieveAll(locations, groupId, filename, new EventMetadata());
    }

    @Override
    public List<Transfer> retrieveAll(List<? extends Location> locations, String groupId, String filename, EventMetadata eventMetadata) throws TransferException {
        return this.transferManager.retrieveAll(new VirtualResource(this.expander.expand(locations), ArtifactPathUtils.formatMetadataPath(groupId, filename)), eventMetadata);
    }

    @Override
    public List<Transfer> retrieveAll(List<? extends Location> locations, ProjectRef ref) throws TransferException {
        return this.retrieveAll(locations, ref, new EventMetadata());
    }

    @Override
    public List<Transfer> retrieveAll(List<? extends Location> locations, ProjectRef ref, EventMetadata eventMetadata) throws TransferException {
        return this.retrieveAll(locations, ref, null, eventMetadata);
    }

    @Override
    public List<Transfer> retrieveAll(List<? extends Location> locations, ProjectRef ref, String filename) throws TransferException {
        return this.retrieveAll(locations, ref, filename, new EventMetadata());
    }

    @Override
    public List<Transfer> retrieveAll(List<? extends Location> locations, ProjectRef ref, String filename, EventMetadata eventMetadata) throws TransferException {
        return this.transferManager.retrieveAll(new VirtualResource(this.expander.expand(locations), ArtifactPathUtils.formatMetadataPath(ref, filename)), eventMetadata);
    }

    @Override
    public Transfer retrieveFirst(List<? extends Location> locations, String groupId) throws TransferException {
        return this.retrieveFirst(locations, groupId, new EventMetadata());
    }

    @Override
    public Transfer retrieveFirst(List<? extends Location> locations, String groupId, EventMetadata eventMetadata) throws TransferException {
        return this.retrieveFirst(locations, groupId, null, eventMetadata);
    }

    @Override
    public Transfer retrieveFirst(List<? extends Location> locations, String groupId, String filename) throws TransferException {
        return this.retrieveFirst(locations, groupId, filename, new EventMetadata());
    }

    @Override
    public Transfer retrieveFirst(List<? extends Location> locations, String groupId, String filename, EventMetadata eventMetadata) throws TransferException {
        return this.transferManager.retrieveFirst(new VirtualResource(this.expander.expand(locations), ArtifactPathUtils.formatMetadataPath(groupId, filename)), eventMetadata);
    }

    @Override
    public Transfer retrieveFirst(List<? extends Location> locations, ProjectRef ref) throws TransferException {
        return this.retrieveFirst(locations, ref, new EventMetadata());
    }

    @Override
    public Transfer retrieveFirst(List<? extends Location> locations, ProjectRef ref, EventMetadata eventMetadata) throws TransferException {
        return this.retrieveFirst(locations, ref, null, eventMetadata);
    }

    @Override
    public Transfer retrieveFirst(List<? extends Location> locations, ProjectRef ref, String filename) throws TransferException {
        return this.retrieveFirst(locations, ref, filename, new EventMetadata());
    }

    @Override
    public Transfer retrieveFirst(List<? extends Location> locations, ProjectRef ref, String filename, EventMetadata eventMetadata) throws TransferException {
        return this.transferManager.retrieveFirst(new VirtualResource(this.expander.expand(locations), ArtifactPathUtils.formatMetadataPath(ref, filename)), eventMetadata);
    }

    @Override
    public Transfer store(Location location, String groupId, InputStream stream) throws TransferException {
        return this.store(location, groupId, stream, new EventMetadata());
    }

    @Override
    public Transfer store(Location location, String groupId, InputStream stream, EventMetadata eventMetadata) throws TransferException {
        return this.store(location, groupId, null, stream, new EventMetadata());
    }

    @Override
    public Transfer store(Location location, String groupId, String filename, InputStream stream) throws TransferException {
        return this.store(location, groupId, filename, stream, new EventMetadata());
    }

    @Override
    public Transfer store(Location location, String groupId, String filename, InputStream stream, EventMetadata eventMetadata) throws TransferException {
        VirtualResource virt = new VirtualResource(this.expander.expand(location), ArtifactPathUtils.formatMetadataPath(groupId, filename));
        ConcreteResource selected = ArtifactRules.selectStorageResource(virt);
        if (selected == null) {
            this.logger.warn("Cannot deploy. No valid deploy points in group.");
            throw new TransferException("No deployment locations available for: {}", virt.toConcreteResources());
        }
        return this.transferManager.store(selected, stream, eventMetadata);
    }

    @Override
    public Transfer store(Location location, ProjectRef ref, InputStream stream) throws TransferException {
        return this.store(location, ref, stream, new EventMetadata());
    }

    @Override
    public Transfer store(Location location, ProjectRef ref, InputStream stream, EventMetadata eventMetadata) throws TransferException {
        return this.store(location, ref, null, stream, new EventMetadata());
    }

    @Override
    public Transfer store(Location location, ProjectRef ref, String filename, InputStream stream) throws TransferException {
        return this.store(location, ref, filename, stream, new EventMetadata());
    }

    @Override
    public Transfer store(Location location, ProjectRef ref, String filename, InputStream stream, EventMetadata eventMetadata) throws TransferException {
        VirtualResource virt = new VirtualResource(this.expander.expand(location), ArtifactPathUtils.formatMetadataPath(ref, filename));
        ConcreteResource selected = ArtifactRules.selectStorageResource(virt);
        if (selected == null) {
            this.logger.warn("Cannot deploy. No valid deploy points in group.");
            throw new TransferException("No deployment locations available for: {}", virt.toConcreteResources());
        }
        return this.transferManager.store(selected, stream, eventMetadata);
    }

    @Override
    public boolean publish(Location location, String groupId, InputStream stream, long length) throws TransferException {
        return this.publish(location, groupId, null, stream, length, null);
    }

    @Override
    public boolean publish(Location location, String groupId, String filename, InputStream stream, long length, String contentType) throws TransferException {
        return this.transferManager.publish(new ConcreteResource(location, ArtifactPathUtils.formatMetadataPath(groupId, filename)), stream, length, contentType);
    }

    @Override
    public boolean publish(Location location, ProjectRef ref, InputStream stream, long length) throws TransferException {
        return this.publish(location, ref, null, stream, length, null);
    }

    @Override
    public boolean publish(Location location, ProjectRef ref, String filename, InputStream stream, long length, String contentType) throws TransferException {
        return this.transferManager.publish(new ConcreteResource(location, ArtifactPathUtils.formatMetadataPath(ref, filename)), stream, length, contentType);
    }
}

