/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.commonjava.maven.atlas.ident.DependencyScope;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.VersionlessArtifactRef;
import org.commonjava.maven.atlas.ident.version.InvalidVersionSpecificationException;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.MavenGAVView;
import org.commonjava.maven.galley.maven.model.view.MavenGAView;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.maven.model.view.ProjectRefView;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DependencyView
extends MavenGAVView {
    private static final String C = "classifier";
    private static final String T = "type";
    private static final String S = "scope";
    private static final String OPTIONAL = "optional";
    private static final String EXCLUSIONS = "exclusions/exclusion";
    private String classifier;
    private String type;
    private DependencyScope scope;
    private Boolean optional;
    private Set<ProjectRefView> exclusions;

    public DependencyView(MavenPomView pomView, Element element) {
        super(pomView, element, "dependencyManagement/dependencies/dependency");
    }

    public boolean isManaged() throws GalleyMavenException {
        return ((MavenPomView)this.xmlView).resolveXPathToNodeFrom(this.elementContext, "ancestor::dependencyManagement", true) != null;
    }

    public synchronized String getClassifier() {
        if (this.classifier == null) {
            this.classifier = this.getValue(C);
        }
        return this.classifier;
    }

    public synchronized String getRawType() {
        if (this.type == null) {
            this.type = this.getValue(T);
        }
        return this.type;
    }

    public synchronized String getType() {
        String type = this.getRawType();
        return type == null ? "jar" : type;
    }

    public synchronized DependencyScope getScope() throws GalleyMavenException {
        if (this.scope == null) {
            String s = this.getValueWithManagement(S);
            this.scope = DependencyScope.getScope(s);
        }
        return this.scope == null ? DependencyScope.compile : this.scope;
    }

    public synchronized boolean isOptional() {
        if (this.optional == null) {
            String val = this.getValue(OPTIONAL);
            this.optional = val == null ? false : Boolean.parseBoolean(val);
        }
        return this.optional;
    }

    public synchronized Set<ProjectRefView> getExclusions() throws GalleyMavenException {
        List<Node> nodes;
        if (this.exclusions == null && (nodes = this.getFirstNodesWithManagement(EXCLUSIONS)) != null) {
            HashSet<ProjectRefView> exclusions = new HashSet<ProjectRefView>();
            for (Node node : nodes) {
                exclusions.add(new MavenGAView((MavenPomView)this.xmlView, (Element)node));
            }
            this.exclusions = exclusions;
        }
        return this.exclusions;
    }

    @Override
    protected String getManagedViewQualifierFragment() {
        StringBuilder sb = new StringBuilder();
        sb.append("ext:resolve(").append("groupId").append("/text()").append(")").append("=\"").append(this.getGroupId()).append("\"").append(" and ").append("ext:resolve(").append("artifactId").append("/text()").append(")").append("=\"").append(this.getArtifactId()).append("\"");
        String cls = this.getClassifier();
        if (cls != null) {
            sb.append(" and ").append("ext:resolve(").append(C).append("/text()").append(")").append("=\"").append(cls).append("\"");
        } else {
            sb.append(" and ").append(" not(").append(C).append(")");
        }
        String type = this.getRawType();
        if (type != null) {
            sb.append(" and ").append("ext:resolve(").append(T).append("/text()").append(")").append("=\"").append(type).append("\"");
        } else {
            sb.append(" and ").append("(").append(" not(").append(T).append(")").append(" or ").append("ext:resolve(").append(T).append("/text()").append(")").append("=\"").append("jar").append("\"").append(")");
        }
        return sb.toString();
    }

    public ArtifactRef asArtifactRef() throws GalleyMavenException {
        try {
            return new ArtifactRef(this.asProjectVersionRef(), this.getType(), this.getClassifier(), this.isOptional());
        }
        catch (IllegalArgumentException e) {
            String classifier = this.getClassifier();
            throw new GalleyMavenException("Cannot render ArtifactRef: {}:{}:{}:{}{}. Reason: {}", (Throwable)e, this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getRawType(), classifier == null ? "" : ":" + classifier, e.getMessage());
        }
        catch (InvalidVersionSpecificationException e) {
            String classifier = this.getClassifier();
            throw new GalleyMavenException("Cannot render ArtifactRef: {}:{}:{}:{}{}. Reason: {}", (Throwable)e, this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getRawType(), classifier == null ? "" : ":" + classifier, e.getMessage());
        }
    }

    public VersionlessArtifactRef asVersionlessArtifactRef() throws GalleyMavenException {
        try {
            return new VersionlessArtifactRef(this.asProjectRef(), this.getType(), this.getClassifier(), this.isOptional());
        }
        catch (IllegalArgumentException e) {
            String classifier = this.getClassifier();
            throw new GalleyMavenException("Cannot render VersionlessArtifactRef: {}:{}:{}{}. Reason: {}", (Throwable)e, this.getGroupId(), this.getArtifactId(), this.getRawType(), classifier == null ? "" : ":" + classifier, e.getMessage());
        }
        catch (InvalidVersionSpecificationException e) {
            String classifier = this.getClassifier();
            throw new GalleyMavenException("Cannot render VersionlessArtifactRef: {}:{}:{}{}. Reason: {}", (Throwable)e, this.getGroupId(), this.getArtifactId(), this.getRawType(), classifier == null ? "" : ":" + classifier, e.getMessage());
        }
    }
}

