/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.MavenGAView;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.maven.model.view.ProjectVersionRefView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class MavenGAVView
extends MavenGAView
implements ProjectVersionRefView {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String version;

    public MavenGAVView(MavenPomView pomView, Element element, String managementXpathFragment) {
        super(pomView, element, managementXpathFragment);
    }

    public MavenGAVView(MavenPomView pomView, Element element) {
        super(pomView, element);
    }

    @Override
    public synchronized String getVersion() throws GalleyMavenException {
        if (this.version == null) {
            this.version = this.getValueWithManagement("version");
        }
        return this.version;
    }

    @Override
    public ProjectVersionRef asProjectVersionRef() throws GalleyMavenException {
        try {
            return new ProjectVersionRef(this.getGroupId(), this.getArtifactId(), this.getVersion());
        }
        catch (IllegalArgumentException e) {
            throw new GalleyMavenException("Cannot render ProjectVersionRef: {}:{}:{}. Reason: {}", (Throwable)e, this.getGroupId(), this.getArtifactId(), this.getVersion(), e.getMessage());
        }
    }

    protected void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return String.format("%s [%s:%s:%s]", this.getClass().getSimpleName(), this.getGroupId(), this.getArtifactId(), this.version == null ? "unresolved" : this.version);
    }

    @Override
    public boolean isValid() {
        try {
            return super.isValid() && !this.containsExpression(this.getVersion());
        }
        catch (GalleyMavenException e) {
            this.logger.warn("Failed to lookup management element. Reason: {}", (Object)e, (Object)e.getMessage());
            return false;
        }
    }
}

