/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.AbstractMavenElementView;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MavenPomElementView
extends AbstractMavenElementView<MavenPomView> {
    private final String managementXpathFragment;
    private String[] managementXpaths;
    private MavenPomElementView managementElement;

    public MavenPomElementView(MavenPomView pomView, Element element, String managementXpathFragment) {
        super(pomView, element);
        this.managementXpathFragment = managementXpathFragment;
    }

    public MavenPomElementView(MavenPomView pomView, Element element) {
        this(pomView, element, null);
    }

    protected String getManagedViewQualifierFragment() {
        return null;
    }

    protected boolean containsExpression(String value) {
        return ((MavenPomView)this.xmlView).containsExpression(value);
    }

    public MavenPomView getPomView() {
        return (MavenPomView)this.xmlView;
    }

    public String getProfileId() {
        return ((MavenPomView)this.xmlView).getProfileIdFor(this.element);
    }

    protected String getValueWithManagement(String named) throws GalleyMavenException {
        MavenPomElementView mgmt;
        String value = this.getValue(named);
        if (value == null && (mgmt = this.getManagementElement()) != null) {
            return mgmt.getValue(named);
        }
        return value;
    }

    private synchronized MavenPomElementView getManagementElement() throws GalleyMavenException {
        if (this.managementElement == null) {
            this.initManagementXpaths();
            if (this.managementXpaths != null) {
                for (String xpath : this.managementXpaths) {
                    MavenPomElementView e = ((MavenPomView)this.xmlView).resolveXPathToElementView(xpath, false, -1);
                    if (e == null) continue;
                    this.managementElement = e;
                    break;
                }
            }
        }
        return this.managementElement;
    }

    protected List<Node> getFirstNodesWithManagement(String path) throws GalleyMavenException {
        MavenPomElementView managedElement;
        List<Node> nodes = ((MavenPomView)this.xmlView).resolveXPathToNodeListFrom(this.elementContext, path, true);
        if ((nodes == null || nodes.isEmpty()) && (managedElement = this.getManagementElement()) != null) {
            return managedElement.getFirstNodesWithManagement(path);
        }
        return nodes;
    }

    private void initManagementXpaths() {
        if (this.managementXpathFragment == null) {
            return;
        }
        String qualifier = this.getManagedViewQualifierFragment();
        if (qualifier == null) {
            return;
        }
        ArrayList<String> xpaths = new ArrayList<String>();
        HashSet<String> activeProfiles = new HashSet<String>(((MavenPomView)this.xmlView).getActiveProfileIds());
        activeProfiles.add(this.getProfileId());
        for (String profileId : activeProfiles) {
            if (profileId == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("/project/profiles/profile[id/text()=\"").append(profileId).append("\"]/").append(this.managementXpathFragment).append('[').append(qualifier).append("]");
            String xp = sb.toString();
            xpaths.add(xp);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/project/").append(this.managementXpathFragment).append('[').append(qualifier).append("]");
        String xp = sb.toString();
        xpaths.add(xp);
        this.managementXpaths = xpaths.toArray(new String[xpaths.size()]);
    }

    @Override
    protected String getValue(String path) {
        String val = super.getValue(path);
        if (this.getProfileId() == null) {
            return ((MavenPomView)this.xmlView).resolveExpressions(val, new String[0]);
        }
        return ((MavenPomView)this.xmlView).resolveExpressions(val, this.getProfileId());
    }
}

