/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.jxpath.JXPathContext;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.VersionlessArtifactRef;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.GalleyMavenRuntimeException;
import org.commonjava.maven.galley.maven.model.view.DependencyView;
import org.commonjava.maven.galley.maven.model.view.DocRef;
import org.commonjava.maven.galley.maven.model.view.ExtensionView;
import org.commonjava.maven.galley.maven.model.view.MavenGAVView;
import org.commonjava.maven.galley.maven.model.view.MavenGAView;
import org.commonjava.maven.galley.maven.model.view.MavenPomElementView;
import org.commonjava.maven.galley.maven.model.view.MavenXmlMixin;
import org.commonjava.maven.galley.maven.model.view.MavenXmlView;
import org.commonjava.maven.galley.maven.model.view.ParentView;
import org.commonjava.maven.galley.maven.model.view.PluginView;
import org.commonjava.maven.galley.maven.model.view.ProjectRefView;
import org.commonjava.maven.galley.maven.model.view.ProjectVersionRefView;
import org.commonjava.maven.galley.maven.model.view.RepositoryView;
import org.commonjava.maven.galley.maven.model.view.XPathManager;
import org.commonjava.maven.galley.maven.parse.JXPathUtils;
import org.commonjava.maven.galley.maven.parse.ResolveFunctions;
import org.commonjava.maven.galley.maven.parse.XMLInfrastructure;
import org.commonjava.maven.galley.maven.spi.defaults.MavenPluginDefaults;
import org.commonjava.maven.galley.maven.spi.defaults.MavenPluginImplications;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MavenPomView
extends MavenXmlView<ProjectVersionRef> {
    public static final String ALL_PROFILES = "*";
    private static final String EXPRESSION_PATTERN = ".*\\$\\{.+\\}.*";
    private static final String TEXT_SUFFIX = "/text()";
    private final ProjectVersionRef versionedRef;
    private final MavenPluginDefaults pluginDefaults;
    private final MavenPluginImplications pluginImplications;
    private final Set<String> activeProfileIds;

    public MavenPomView(ProjectVersionRef ref, List<DocRef<ProjectVersionRef>> stack, XPathManager xpath, MavenPluginDefaults pluginDefaults, MavenPluginImplications pluginImplications, XMLInfrastructure xml, String ... activeProfileIds) {
        super(stack, xpath, xml, "/project/parent", "/project/artifactId");
        this.pluginImplications = pluginImplications;
        this.activeProfileIds = new HashSet<String>(Arrays.asList(activeProfileIds));
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a POM view with no POMs!");
        }
        this.versionedRef = ref;
        this.pluginDefaults = pluginDefaults;
    }

    public Set<String> getActiveProfileIds() {
        return this.activeProfileIds.contains(ALL_PROFILES) ? this.getProfileIds() : this.activeProfileIds;
    }

    public Set<String> getProfileIds() {
        return new HashSet<String>(this.resolveXPathExpressionToAggregatedList("/profiles/profile/id/text()", false, -1));
    }

    public String resolveMavenExpression(String expression, String ... activeProfileIds) throws GalleyMavenException {
        String expr = expression.replace('.', '/');
        if (expr.startsWith("pom")) {
            expr = "/project/" + expr.substring(4);
        }
        if (!expr.startsWith("/")) {
            expr = "/" + expr;
        }
        if (!expr.startsWith("/project")) {
            expr = "/project" + expr;
        }
        String value = this.resolveXPathExpression(expr, true, -1, new String[0]);
        for (int i = 0; value == null && activeProfileIds != null && i < activeProfileIds.length; ++i) {
            String profileId = activeProfileIds[i];
            value = this.resolveXPathExpression("//profile[id/text()=\"" + profileId + "\"]/properties/" + expression, true, -1, activeProfileIds);
        }
        if (value == null) {
            List<Node> propertyNodes = this.resolveXPathToAggregatedNodeList("/project/properties/*", true, -1);
            for (Node propertyNode : propertyNodes) {
                if (!expression.equals(propertyNode.getNodeName())) continue;
                value = propertyNode.getTextContent().trim();
                break;
            }
        }
        return value;
    }

    public synchronized ProjectVersionRef asProjectVersionRef() {
        return this.versionedRef;
    }

    public String getGroupId() throws GalleyMavenException {
        return this.asProjectVersionRef().getGroupId();
    }

    public String getArtifactId() throws GalleyMavenException {
        return this.asProjectVersionRef().getArtifactId();
    }

    public String getVersion() throws GalleyMavenException {
        return this.asProjectVersionRef().getVersionString();
    }

    public String getProfileIdFor(Element element) {
        Node parent = element;
        while ((parent = parent.getParentNode()) != null && !"profile".equals(parent.getNodeName())) {
        }
        if (parent == null) {
            return null;
        }
        return (String)JXPathUtils.newContext(parent).getValue("id");
    }

    public List<DependencyView> getAllDirectDependencies() throws GalleyMavenException {
        String xp = "//dependency[not(ancestor::dependencyManagement) and not(ancestor::build) and not(ancestor::reporting)]";
        List<MavenPomElementView> depNodes = this.resolveXPathToAggregatedElementViewList("//dependency[not(ancestor::dependencyManagement) and not(ancestor::build) and not(ancestor::reporting)]", true, -1);
        ArrayList<DependencyView> depViews = new ArrayList<DependencyView>(depNodes.size());
        for (MavenPomElementView node : depNodes) {
            depViews.add(new DependencyView(node.getPomView(), node.getElement()));
        }
        return depViews;
    }

    public List<DependencyView> getAllManagedDependenciesUnfiltered() {
        List<MavenPomElementView> depNodes = this.resolveXPathToAggregatedElementViewList("//dependencyManagement/dependencies/dependency[not(scope/text()=\"import\")]", true, -1);
        ArrayList<DependencyView> depViews = new ArrayList<DependencyView>(depNodes.size());
        for (MavenPomElementView node : depNodes) {
            depViews.add(new DependencyView(node.getPomView(), node.getElement()));
        }
        return depViews;
    }

    public List<DependencyView> getAllManagedDependencies() throws GalleyMavenException {
        List<DependencyView> raw = this.getAllManagedDependenciesUnfiltered();
        ArrayList<DependencyView> depViews = new ArrayList<DependencyView>(raw.size());
        HashSet<VersionlessArtifactRef> seen = new HashSet<VersionlessArtifactRef>();
        for (DependencyView dv : raw) {
            VersionlessArtifactRef var = dv.asVersionlessArtifactRef();
            if (seen.contains(var)) continue;
            depViews.add(dv);
            seen.add(var);
        }
        return depViews;
    }

    public List<DependencyView> getManagedDependenciesNoImports() {
        List<MavenPomElementView> depNodes = this.resolveXPathToAggregatedElementViewList("//dependencyManagement/dependencies/dependency[not(scope/text()=\"import\")]", true, -1, false);
        ArrayList<DependencyView> depViews = new ArrayList<DependencyView>(depNodes.size());
        for (MavenPomElementView node : depNodes) {
            depViews.add(new DependencyView(node.getPomView(), node.getElement()));
        }
        return depViews;
    }

    public List<DependencyView> getAllBOMs() throws GalleyMavenException {
        List<MavenPomElementView> depNodes = this.resolveXPathToAggregatedElementViewList("//dependencyManagement/dependencies/dependency[type/text()=\"pom\" and scope/text()=\"import\"]", true, -1);
        ArrayList<DependencyView> depViews = new ArrayList<DependencyView>(depNodes.size());
        for (MavenPomElementView node : depNodes) {
            depViews.add(new DependencyView(node.getPomView(), node.getElement()));
        }
        return depViews;
    }

    public String resolveXPathExpression(String path, boolean localOnly) throws GalleyMavenException {
        String value = this.resolveXPathExpression(path, true, localOnly ? 0 : -1, new String[0]);
        return value;
    }

    public Element resolveXPathToElement(String path, boolean localOnly) throws GalleyMavenException {
        Node node = this.resolveXPathToNode(path, true, localOnly ? 0 : -1);
        if (node != null && node.getNodeType() == 1) {
            return (Element)node;
        }
        return null;
    }

    public List<MavenPomElementView> resolveXPathToElements(String path, boolean localOnly) throws GalleyMavenException {
        return this.resolveXPathToAggregatedElementViewList(path, true, localOnly ? 0 : -1);
    }

    public synchronized Node resolveXPathToNode(String path, boolean localOnly) throws GalleyMavenException {
        Node node = this.resolveXPathToNode(path, true, localOnly ? 0 : -1);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenPomElementView resolveXPathToElementView(String path, boolean cachePath, int maxDepth) throws GalleyMavenRuntimeException {
        int maxAncestry = maxDepth;
        for (String pathPrefix : this.localOnlyPaths) {
            if (!path.startsWith(pathPrefix)) continue;
            maxAncestry = 0;
            break;
        }
        int ancestryDepth = 0;
        Element n = null;
        for (DocRef dr : this.stack) {
            if (maxAncestry > -1 && ancestryDepth > maxAncestry) break;
            MavenPomView oldView = ResolveFunctions.getPomView();
            try {
                ResolveFunctions.setPomView(this);
                n = (Element)dr.getDocContext().selectSingleNode(path);
            }
            finally {
                ResolveFunctions.setPomView(oldView);
            }
            if (n != null) break;
            ++ancestryDepth;
        }
        if (n != null) {
            return new MavenPomElementView(this, n);
        }
        MavenPomElementView result = null;
        for (MavenXmlMixin mixin : this.mixins) {
            if (mixin.matches(path)) {
                MavenPomView mixinView = (MavenPomView)mixin.getMixin();
                result = mixinView.resolveXPathToElementView(path, true, maxAncestry);
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public DependencyView asDependency(Element depElement) {
        return new DependencyView(this, depElement);
    }

    public PluginView asPlugin(Element element) {
        return new PluginView(this, element, this.pluginDefaults, this.pluginImplications);
    }

    public ParentView getParent() throws GalleyMavenException {
        Element parentEl = (Element)this.resolveXPathToNode("/project/parent", true);
        if (parentEl != null) {
            return new ParentView(this, parentEl);
        }
        return null;
    }

    public List<ExtensionView> getBuildExtensions() throws GalleyMavenException {
        List<MavenPomElementView> list = this.resolveXPathToAggregatedElementViewList("/project//extensions/extension", true, -1);
        ArrayList<ExtensionView> result = new ArrayList<ExtensionView>(list.size());
        for (MavenPomElementView node : list) {
            if (node == null) continue;
            result.add(new ExtensionView(node.getPomView(), node.getElement()));
        }
        return result;
    }

    public List<PluginView> getAllPluginsMatching(String path) throws GalleyMavenException {
        List<MavenPomElementView> list = this.resolveXPathToAggregatedElementViewList(path, true, -1);
        ArrayList<PluginView> result = new ArrayList<PluginView>(list.size());
        for (MavenPomElementView node : list) {
            if (node == null) continue;
            result.add(new PluginView(node.getPomView(), node.getElement(), this.pluginDefaults, this.pluginImplications));
        }
        return result;
    }

    public List<DependencyView> getAllDependenciesMatching(String path) throws GalleyMavenException {
        List<MavenPomElementView> list = this.resolveXPathToAggregatedElementViewList(path, true, -1);
        ArrayList<DependencyView> result = new ArrayList<DependencyView>(list.size());
        for (MavenPomElementView node : list) {
            if (node == null) continue;
            result.add(new DependencyView(node.getPomView(), node.getElement()));
        }
        return result;
    }

    public List<PluginView> getAllBuildPlugins() throws GalleyMavenException {
        List<MavenPomElementView> list = this.resolveXPathToAggregatedElementViewList("/project//build/plugins/plugin", true, -1);
        ArrayList<PluginView> result = new ArrayList<PluginView>(list.size());
        for (MavenPomElementView node : list) {
            if (node == null) continue;
            result.add(new PluginView(node.getPomView(), node.getElement(), this.pluginDefaults, this.pluginImplications));
        }
        return result;
    }

    public List<PluginView> getAllManagedBuildPlugins() throws GalleyMavenException {
        List<MavenPomElementView> list = this.resolveXPathToAggregatedElementViewList("/project//pluginManagement/plugins/plugin", true, -1);
        ArrayList<PluginView> result = new ArrayList<PluginView>(list.size());
        for (MavenPomElementView node : list) {
            if (node == null) continue;
            result.add(new PluginView(node.getPomView(), node.getElement(), this.pluginDefaults, this.pluginImplications));
        }
        return result;
    }

    public List<RepositoryView> getAllRepositories() {
        List<MavenPomElementView> list = this.resolveXPathToAggregatedElementViewList("/project//repositories/repository", true, -1);
        ArrayList<RepositoryView> result = new ArrayList<RepositoryView>(list.size());
        for (MavenPomElementView node : list) {
            if (node == null) continue;
            result.add(new RepositoryView(node.getPomView(), node.getElement()));
        }
        return result;
    }

    public List<RepositoryView> getAllPluginRepositories() {
        List<MavenPomElementView> list = this.resolveXPathToAggregatedElementViewList("/project//pluginRepositories/pluginRepository", true, -1);
        ArrayList<RepositoryView> result = new ArrayList<RepositoryView>(list.size());
        for (MavenPomElementView node : list) {
            if (node == null) continue;
            result.add(new RepositoryView(node.getPomView(), node.getElement()));
        }
        return result;
    }

    public List<RepositoryView> getActiveRepositories() {
        List<MavenPomElementView> list = this.resolveXPathToAggregatedElementViewList("/project//repositories/repository", true, -1);
        ArrayList<RepositoryView> result = new ArrayList<RepositoryView>(list.size());
        for (MavenPomElementView node : list) {
            if (node == null || !this.activeProfileIds.contains(ALL_PROFILES) && !this.activeProfileIds.contains(this.getProfileIdFor(node.getElement()))) continue;
            result.add(new RepositoryView(node.getPomView(), node.getElement()));
        }
        return result;
    }

    public List<RepositoryView> getActivePluginRepositories() {
        List<MavenPomElementView> list = this.resolveXPathToAggregatedElementViewList("/project//pluginRepositories/pluginRepository", true, -1);
        ArrayList<RepositoryView> result = new ArrayList<RepositoryView>(list.size());
        for (MavenPomElementView node : list) {
            if (node == null || !this.activeProfileIds.contains(ALL_PROFILES) && !this.activeProfileIds.contains(this.getProfileIdFor(node.getElement()))) continue;
            result.add(new RepositoryView(node.getPomView(), node.getElement()));
        }
        return result;
    }

    public List<ProjectVersionRefView> getProjectVersionRefs(String path) throws GalleyMavenException {
        List<MavenPomElementView> list = this.resolveXPathToAggregatedElementViewList(path, true, -1);
        ArrayList<ProjectVersionRefView> result = new ArrayList<ProjectVersionRefView>(list.size());
        for (MavenPomElementView node : list) {
            if (node == null) continue;
            result.add(new MavenGAVView(node.getPomView(), node.getElement()));
        }
        return result;
    }

    public List<ProjectRefView> getProjectRefs(String path) throws GalleyMavenException {
        List<MavenPomElementView> list = this.resolveXPathToAggregatedElementViewList(path, true, -1);
        ArrayList<ProjectRefView> result = new ArrayList<ProjectRefView>(list.size());
        for (MavenPomElementView node : list) {
            if (node == null) continue;
            String v = node.getValue("version");
            if (v != null) {
                result.add(new MavenGAVView(this, (Element)((Object)node)));
                continue;
            }
            result.add(new MavenGAView(this, (Element)((Object)node)));
        }
        return result;
    }

    public List<MavenPomElementView> resolveXPathToAggregatedElementViewList(String path, boolean cachePath, int maxDepth) {
        return this.resolveXPathToAggregatedElementViewList(path, cachePath, maxDepth, true);
    }

    public synchronized List<MavenPomElementView> resolveXPathToAggregatedElementViewList(String path, boolean cachePath, int maxDepth, boolean includeMixins) throws GalleyMavenRuntimeException {
        int maxAncestry = maxDepth;
        for (String pathPrefix : this.localOnlyPaths) {
            if (!path.startsWith(pathPrefix)) continue;
            maxAncestry = 0;
            break;
        }
        int ancestryDepth = 0;
        ArrayList<MavenPomElementView> result = new ArrayList<MavenPomElementView>();
        for (DocRef dr : this.stack) {
            if (maxAncestry > -1 && ancestryDepth > maxAncestry) break;
            List<Node> nodes = this.getLocalNodeList(dr.getDocContext(), path);
            if (nodes != null) {
                for (Node node : nodes) {
                    result.add(new MavenPomElementView(this, (Element)node));
                }
            }
            ++ancestryDepth;
        }
        if (includeMixins) {
            for (MavenXmlMixin mixin : this.mixins) {
                MavenPomView mixinView;
                List<MavenPomElementView> nodes;
                if (!mixin.matches(path) || (nodes = (mixinView = (MavenPomView)mixin.getMixin()).resolveXPathToAggregatedElementViewList(path, cachePath, maxAncestry, includeMixins)) == null) continue;
                for (MavenPomElementView node : nodes) {
                    result.add(node);
                }
            }
        }
        return result;
    }

    protected String resolveXPathExpressionFrom(JXPathContext context, String path) {
        String p = this.trimTextSuffix(path);
        Node result = this.resolveXPathToNodeFrom(context, p, true);
        if (result != null && result.getNodeType() == 3) {
            return this.resolveExpressions(result.getTextContent().trim(), new String[0]);
        }
        return null;
    }

    protected List<String> resolveXPathExpressionToListFrom(JXPathContext context, String path) throws GalleyMavenException {
        String p = this.trimTextSuffix(path);
        List<Node> nodes = this.resolveXPathToNodeListFrom(context, p, true);
        ArrayList<String> result = new ArrayList<String>(nodes.size());
        for (Node node : nodes) {
            if (node == null || node.getNodeType() != 3) continue;
            result.add(this.resolveExpressions(node.getTextContent().trim(), new String[0]));
        }
        return result;
    }

    public String resolveXPathExpression(String path, boolean cachePath, int maxAncestry, String ... activeProfileIds) {
        String p = this.trimTextSuffix(path);
        String raw = this.resolveXPathToRawString(p, cachePath, maxAncestry);
        if (raw != null) {
            return this.resolveExpressions(raw, activeProfileIds);
        }
        return null;
    }

    private String trimTextSuffix(String path) {
        String p = path;
        if (p.endsWith(TEXT_SUFFIX)) {
            p = p.substring(0, p.length() - TEXT_SUFFIX.length());
        }
        return p;
    }

    public List<String> resolveXPathExpressionToAggregatedList(String path, boolean cachePath, int maxAncestry) {
        String p = this.trimTextSuffix(path);
        List<Node> nodes = this.resolveXPathToAggregatedNodeList(p, cachePath, maxAncestry);
        ArrayList<String> result = new ArrayList<String>(nodes.size());
        for (Node node : nodes) {
            if (node == null || node.getNodeType() != 3) continue;
            result.add(this.resolveExpressions(node.getTextContent().trim(), new String[0]));
        }
        return result;
    }

    protected boolean containsExpression(String value) {
        return value != null && value.matches(EXPRESSION_PATTERN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveExpressions(String value, String ... activeProfileIds) {
        if (!this.containsExpression(value)) {
            return value;
        }
        MavenPomView mavenPomView = this;
        synchronized (mavenPomView) {
            if (this.ssi == null) {
                this.ssi = new StringSearchInterpolator();
                this.ssi.addValueSource(new MavenPomViewVS(this, activeProfileIds));
            }
        }
        try {
            String result = this.ssi.interpolate(value);
            if (result == null || result.trim().length() < 1) {
                result = value;
            }
            return result;
        }
        catch (InterpolationException e) {
            this.logger.error(String.format("Failed to resolve expressions in: '%s'. Reason: %s", value, e.getMessage()), e);
            return value;
        }
    }

    private static final class MavenPomViewVS
    implements ValueSource {
        private final MavenPomView view;
        private final List<Object> feedback = new ArrayList<Object>();
        private final String[] activeProfileIds;

        public MavenPomViewVS(MavenPomView view, String[] activeProfileIds) {
            this.view = view;
            this.activeProfileIds = activeProfileIds;
        }

        @Override
        public void clearFeedback() {
            this.feedback.clear();
        }

        @Override
        public List getFeedback() {
            return this.feedback;
        }

        @Override
        public Object getValue(String expr) {
            try {
                String value = this.view.resolveMavenExpression(expr, this.activeProfileIds);
                return value;
            }
            catch (GalleyMavenException e) {
                this.feedback.add(String.format("Error resolving maven expression: '%s'", expr));
                this.feedback.add(e);
                return null;
            }
        }
    }
}

