/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.MavenGAVView;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.maven.model.view.PluginDependencyView;
import org.commonjava.maven.galley.maven.spi.defaults.MavenPluginDefaults;
import org.commonjava.maven.galley.maven.spi.defaults.MavenPluginImplications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PluginView
extends MavenGAVView {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MavenPluginDefaults pluginDefaults;
    private List<PluginDependencyView> pluginDependencies;
    private final MavenPluginImplications pluginImplications;

    protected PluginView(MavenPomView pomView, Element element, MavenPluginDefaults pluginDefaults, MavenPluginImplications pluginImplications) {
        super(pomView, element, "build/pluginManagement/plugins/plugin");
        this.pluginDefaults = pluginDefaults;
        this.pluginImplications = pluginImplications;
    }

    public boolean isManaged() throws GalleyMavenException {
        return ((MavenPomView)this.xmlView).resolveXPathToNodeFrom(this.elementContext, "ancestor::pluginManagement", true) != null;
    }

    public synchronized List<PluginDependencyView> getLocalPluginDependencies() throws GalleyMavenException {
        if (this.pluginDependencies == null) {
            ArrayList<PluginDependencyView> result = new ArrayList<PluginDependencyView>();
            List<Node> nodes = this.getFirstNodesWithManagement("dependencies/dependency");
            if (nodes != null) {
                for (Node node : nodes) {
                    this.logger.debug("Adding plugin dependency for: {}", (Object)node.getNodeName());
                    result.add(new PluginDependencyView((MavenPomView)this.xmlView, this, (Element)node));
                }
                this.pluginDependencies = result;
            }
        }
        return this.pluginDependencies;
    }

    public Set<PluginDependencyView> getImpliedPluginDependencies() throws GalleyMavenException {
        return this.pluginImplications.getImpliedPluginDependencies(this);
    }

    @Override
    public synchronized String getVersion() throws GalleyMavenException {
        if (super.getVersion() == null) {
            this.setVersion(this.pluginDefaults.getDefaultVersion(this.getGroupId(), this.getArtifactId()));
        }
        return super.getVersion();
    }

    @Override
    public synchronized String getGroupId() {
        String gid = super.getGroupId();
        if (gid == null) {
            this.setGroupId(this.pluginDefaults.getDefaultGroupId(this.getArtifactId()));
        }
        return super.getGroupId();
    }

    @Override
    protected String getManagedViewQualifierFragment() {
        String dgid;
        StringBuilder sb = new StringBuilder();
        String aid = this.getArtifactId();
        String gid = this.getGroupId();
        if (!gid.equals(dgid = this.pluginDefaults.getDefaultGroupId(aid))) {
            sb.append("ext:resolve(").append("groupId").append("/text()").append(")").append("=\"").append(gid).append("\"").append(" and ");
        }
        sb.append("ext:resolve(").append("artifactId").append("/text()").append(")").append("=\"").append(aid).append("\"");
        return sb.toString();
    }
}

