/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.parse;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.util.JoinString;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.maven.ArtifactMetadataManager;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.DocRef;
import org.commonjava.maven.galley.maven.model.view.XPathManager;
import org.commonjava.maven.galley.maven.model.view.meta.MavenMetadataView;
import org.commonjava.maven.galley.maven.parse.AbstractMavenXmlReader;
import org.commonjava.maven.galley.maven.parse.XMLInfrastructure;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.spi.transport.LocationExpander;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class MavenMetadataReader
extends AbstractMavenXmlReader<ProjectRef> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private ArtifactMetadataManager metadataManager;
    @Inject
    private XPathManager xpath;

    protected MavenMetadataReader() {
    }

    public MavenMetadataReader(XMLInfrastructure xml, LocationExpander locationExpander, ArtifactMetadataManager metadataManager, XPathManager xpath) {
        super(xml, locationExpander);
        this.metadataManager = metadataManager;
        this.xpath = xpath;
    }

    public MavenMetadataView getMetadata(ProjectRef ref, List<? extends Location> locations) throws GalleyMavenException {
        return this.getMetadata(ref, locations, new EventMetadata());
    }

    public MavenMetadataView getMetadata(ProjectRef ref, List<? extends Location> locations, EventMetadata eventMetadata) throws GalleyMavenException {
        List<Transfer> transfers;
        ArrayList<DocRef<ProjectRef>> docs = new ArrayList<DocRef<ProjectRef>>(locations.size());
        Map<Location, DocRef<ProjectRef>> cached = this.getAllCached(ref, locations);
        ArrayList<? extends Location> toRetrieve = new ArrayList<Location>(locations);
        for (Location location : locations) {
            DocRef<ProjectRef> dr = cached.get(location);
            if (dr != null) {
                docs.add(dr);
                toRetrieve.remove(location);
                continue;
            }
            docs.add(null);
        }
        try {
            transfers = this.metadataManager.retrieveAll(toRetrieve, ref, eventMetadata);
        }
        catch (TransferException transferException) {
            throw new GalleyMavenException("Failed to resolve metadata for: {} from: {}. Reason: {}", (Throwable)transferException, ref, locations, transferException.getMessage());
        }
        this.logger.debug("Resolved {} transfers:\n  {}", (Object)transfers.size(), (Object)new JoinString("\n  ", transfers));
        if (transfers != null && !transfers.isEmpty()) {
            for (Transfer transfer : transfers) {
                DocRef<ProjectRef> dr = new DocRef<ProjectRef>(ref, transfer.getLocation(), this.xml.parse(transfer, eventMetadata));
                int idx = locations.indexOf(transfer.getLocation());
                if (idx > -1) {
                    docs.set(idx, dr);
                    continue;
                }
                docs.add(dr);
            }
        }
        Iterator iterator = docs.iterator();
        while (iterator.hasNext()) {
            DocRef docRef = (DocRef)iterator.next();
            if (docRef != null) continue;
            iterator.remove();
        }
        this.logger.debug("Got {} metadata documents for: {}", (Object)docs.size(), (Object)ref);
        return new MavenMetadataView(docs, this.xpath, this.xml);
    }

    public MavenMetadataView readMetadata(ProjectRef ref, List<Transfer> transfers) throws GalleyMavenException {
        return this.readMetadata(ref, transfers, new EventMetadata());
    }

    public MavenMetadataView readMetadata(ProjectRef ref, List<Transfer> transfers, EventMetadata eventMetadata) throws GalleyMavenException {
        ArrayList<DocRef<ProjectRef>> docs = new ArrayList<DocRef<ProjectRef>>(transfers.size());
        if (transfers != null && !transfers.isEmpty()) {
            for (Transfer transfer : transfers) {
                DocRef<ProjectRef> dr;
                if (transfer == null || (dr = new DocRef<ProjectRef>(ref, transfer.getLocation(), this.xml.parse(transfer, eventMetadata))) == null) continue;
                docs.add(dr);
            }
        }
        if (docs.isEmpty()) {
            return null;
        }
        return new MavenMetadataView(docs, this.xpath, this.xml);
    }
}

