/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.parse;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.galley.model.Transfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomPeek {
    private static final String G = "g";
    private static final String A = "a";
    private static final String V = "v";
    private static final String PG = "pg";
    private static final String PA = "pa";
    private static final String PV = "pv";
    private static final String PKG = "pkg";
    private static final String PRP = "prp";
    private static final String[] COORD_KEYS = new String[]{"g", "a", "v", "pg", "pa", "pv", "pkg", "prp"};
    private static final String MODULES_ELEM = "modules";
    private static final String PLUGINS_ELEM = "plugins";
    private static final Map<String, String> CAPTURED_PATHS = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("project:groupId", PomPeek.G);
            this.put("project:artifactId", PomPeek.A);
            this.put("project:version", PomPeek.V);
            this.put("project:packaging", PomPeek.PKG);
            this.put("project:parent:groupId", PomPeek.PG);
            this.put("project:parent:artifactId", PomPeek.PA);
            this.put("project:parent:version", PomPeek.PV);
            this.put("project:parent:relativePath", PomPeek.PRP);
        }
    };
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ProjectVersionRef key;
    private final Map<String, String> elementValues = new HashMap<String, String>();
    private final Set<String> modules = new HashSet<String>();
    private final File pom;
    private ProjectVersionRef parentKey;
    private boolean inheritanceRoot = false;
    private final Transfer transfer;
    private final boolean captureModules;
    private final InputStream stream;

    public PomPeek(File pom) {
        this.pom = pom;
        this.transfer = null;
        this.stream = null;
        this.captureModules = true;
        this.init();
    }

    public PomPeek(Transfer transfer) {
        this.pom = null;
        this.transfer = transfer;
        this.stream = null;
        this.captureModules = true;
        this.init();
    }

    public PomPeek(String content) {
        this.pom = null;
        this.transfer = null;
        this.stream = new ByteArrayInputStream(content.getBytes());
        this.captureModules = true;
        this.init();
    }

    public PomPeek(InputStream stream) {
        this.pom = null;
        this.transfer = null;
        this.stream = stream;
        this.captureModules = true;
        this.init();
    }

    public PomPeek(File pom, boolean captureModules) {
        this.pom = pom;
        this.transfer = null;
        this.stream = null;
        this.captureModules = captureModules;
        this.init();
    }

    public PomPeek(Transfer transfer, boolean captureModules) {
        this.pom = null;
        this.transfer = transfer;
        this.stream = null;
        this.captureModules = captureModules;
        this.init();
    }

    public PomPeek(String content, boolean captureModules) {
        this.pom = null;
        this.transfer = null;
        this.stream = new ByteArrayInputStream(content.getBytes());
        this.captureModules = captureModules;
        this.init();
    }

    public PomPeek(InputStream stream, boolean captureModules) {
        this.pom = null;
        this.transfer = null;
        this.stream = stream;
        this.captureModules = captureModules;
        this.init();
    }

    private void init() {
        this.parseCoordElements();
        if (!this.createCoordinateInfo()) {
            this.logger.warn("Could not peek at POM coordinate for: " + this.pom + "This POM will NOT be available as an ancestor to other models during effective-model building.");
        }
    }

    public String getParentRelativePath() {
        return this.elementValues.get(PRP);
    }

    public Set<String> getModules() {
        return this.modules;
    }

    public File getPom() {
        return this.pom;
    }

    public ProjectVersionRef getKey() {
        return this.key;
    }

    public ProjectVersionRef getParentKey() {
        return this.parentKey;
    }

    /*
     * Exception decompiling
     */
    private void parseCoordElements() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 37[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean foundAll() {
        for (String key : COORD_KEYS) {
            if (this.elementValues.containsKey(key)) continue;
            return false;
        }
        return !this.captureModules || !"pom".equals(this.elementValues.get(PKG));
    }

    private boolean captureValue(String elem, Stack<String> path, XMLStreamReader xml) throws XMLStreamException {
        boolean isModule = path.contains(MODULES_ELEM) && !path.contains(PLUGINS_ELEM);
        path.push(elem);
        String pathStr = StringUtils.join(path, ":");
        String key = CAPTURED_PATHS.get(pathStr);
        if (key != null) {
            this.elementValues.put(key, xml.getElementText().trim());
            return true;
        }
        if (this.captureModules && isModule) {
            this.modules.add(xml.getElementText().trim());
            return true;
        }
        return false;
    }

    private boolean createCoordinateInfo() {
        String v = this.elementValues.get(V);
        String pv = this.elementValues.get(PV);
        if (StringUtils.isEmpty(v)) {
            v = pv;
        }
        String g = this.elementValues.get(G);
        String pg = this.elementValues.get(PG);
        if (StringUtils.isEmpty(g)) {
            g = pg;
        }
        String a = this.elementValues.get(A);
        String pa = this.elementValues.get(PA);
        boolean valid = false;
        if (this.isValidArtifactId(a) && this.isValidGroupId(g) && this.isValidVersion(v)) {
            this.key = new ProjectVersionRef(g, a, v);
            valid = true;
        }
        if (this.isValidArtifactId(pa) && this.isValidGroupId(pg) && this.isValidVersion(pv)) {
            this.parentKey = new ProjectVersionRef(pg, pa, pv);
        }
        return valid;
    }

    private boolean isValidVersion(String version) {
        if (StringUtils.isEmpty(version)) {
            return false;
        }
        if ("version".equals(version)) {
            return false;
        }
        return !"parentVersion".equals(version);
    }

    private boolean isValidGroupId(String groupId) {
        if (StringUtils.isEmpty(groupId)) {
            return false;
        }
        if (groupId.contains("${")) {
            return false;
        }
        if ("parentGroupId".equals(groupId)) {
            return false;
        }
        return !"groupId".equals(groupId);
    }

    private boolean isValidArtifactId(String artifactId) {
        if (StringUtils.isEmpty(artifactId)) {
            return false;
        }
        if (artifactId.contains("${")) {
            return false;
        }
        if ("parentArtifactId".equals(artifactId)) {
            return false;
        }
        return !"artifactId".equals(artifactId);
    }

    public void setInheritanceRoot(boolean b) {
        this.inheritanceRoot = b;
    }

    public boolean isInheritanceRoot() {
        return this.inheritanceRoot;
    }
}

