/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.parse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.maven.GalleyMavenRuntimeException;
import org.commonjava.maven.galley.maven.parse.GalleyMavenXMLException;
import org.commonjava.maven.galley.model.Transfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@ApplicationScoped
public class XMLInfrastructure {
    private static final Set<String> XML_ENTITIES = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("&quot;");
            this.add("&amp;");
            this.add("&apos;");
            this.add("&lt;");
            this.add("&gt;");
        }
    };
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DocumentBuilderFactory dbFactory;
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private final XMLInputFactory safeInputFactory;

    public XMLInfrastructure() {
        if (!this.transformerFactory.getClass().getName().contains("redirected")) {
            this.safeInputFactory = XMLInputFactory.newInstance();
            this.safeInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            this.safeInputFactory.setProperty("javax.xml.stream.isValidating", false);
        } else {
            this.logger.warn("Somebody is playing games with the TransformerFactory...we cannot use it safely: {}", (Object)this.transformerFactory);
            this.safeInputFactory = null;
        }
        this.dbFactory = DocumentBuilderFactory.newInstance();
        this.dbFactory.setValidating(false);
        this.dbFactory.setXIncludeAware(false);
        this.dbFactory.setNamespaceAware(false);
        this.dbFactory.setIgnoringComments(true);
        this.dbFactory.setExpandEntityReferences(false);
        this.dbFactory.setCoalescing(true);
    }

    public Element createElement(Node in, String relativePath, Map<String, String> leafElements) {
        Element below;
        Document doc;
        if (in instanceof Document) {
            doc = (Document)in;
            below = doc.getDocumentElement();
        } else if (in instanceof Element) {
            below = (Element)in;
            doc = below.getOwnerDocument();
        } else {
            throw new IllegalArgumentException("Cannot create nodes/content under a node of type: " + in);
        }
        Element insertionPoint = below;
        if (relativePath != null && relativePath.length() > 0 && !"/".equals(relativePath)) {
            String[] intermediates = relativePath.split("/");
            for (int i = 0; i < intermediates.length - 1; ++i) {
                NodeList nl = insertionPoint.getElementsByTagNameNS(below.getNamespaceURI(), intermediates[i]);
                if (nl != null && nl.getLength() > 0) {
                    insertionPoint = (Element)nl.item(0);
                    continue;
                }
                Element e = doc.createElementNS(below.getNamespaceURI(), intermediates[i]);
                insertionPoint.appendChild(e);
                insertionPoint = e;
            }
            Element e = doc.createElementNS(below.getNamespaceURI(), intermediates[intermediates.length - 1]);
            insertionPoint.appendChild(e);
            insertionPoint = e;
        }
        for (Map.Entry<String, String> entry : leafElements.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Element e = doc.createElementNS(below.getNamespaceURI(), key);
            insertionPoint.appendChild(e);
            e.setTextContent(value);
        }
        return insertionPoint;
    }

    public DocumentBuilder newDocumentBuilder() throws GalleyMavenXMLException {
        try {
            return this.dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new GalleyMavenXMLException("Failed to create DocumentBuilder: %s", (Throwable)e, e.getMessage());
        }
    }

    public Transformer newTransformer() throws GalleyMavenXMLException {
        try {
            return this.transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new GalleyMavenXMLException("Failed to create Transformer: %s", (Throwable)e, e.getMessage());
        }
    }

    public String toXML(Node node) {
        return this.toXML(node, true);
    }

    public String toXML(Node node, boolean printXmlDeclaration) {
        String result = null;
        try {
            StringWriter sw = new StringWriter();
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", printXmlDeclaration ? "no" : "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DocumentBuilder docBuilder = this.dbFactory.newDocumentBuilder();
            Node doc = node instanceof Document ? node : docBuilder.newDocument().importNode(node, true);
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            result = sw.toString();
        }
        catch (TransformerException e) {
            throw new GalleyMavenRuntimeException("Failed to render to XML: %s. Reason: %s", (Throwable)e, node, e.getMessage());
        }
        catch (DOMException e) {
            throw new GalleyMavenRuntimeException("Failed to render to XML: %s. Reason: %s", (Throwable)e, node, e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new GalleyMavenRuntimeException("Failed to render to XML: %s. Reason: %s", (Throwable)e, node, e.getMessage());
        }
        return result;
    }

    public Document parseDocument(Object docSource, InputStream stream) throws GalleyMavenXMLException {
        String xml;
        if (stream == null) {
            throw new GalleyMavenXMLException("Cannot parse null input stream from: %s.", docSource);
        }
        try {
            xml = IOUtils.toString(stream);
        }
        catch (IOException e) {
            throw new GalleyMavenXMLException("Failed to read raw data from XML stream: %s", (Throwable)e, e.getMessage());
        }
        this.logger.debug("Parsing:\n\n{}\n\n", (Object)xml);
        Document doc = null;
        try {
            doc = this.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        }
        catch (GalleyMavenXMLException e) {
            IOUtils.closeQuietly(stream);
            doc = this.fallbackParseDocument(xml, docSource, e);
        }
        catch (SAXException e) {
            IOUtils.closeQuietly(stream);
            doc = this.fallbackParseDocument(xml, docSource, e);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(stream);
            doc = this.fallbackParseDocument(xml, docSource, e);
        }
        return doc;
    }

    private Document fallbackParseDocument(String xml, Object docSource, Exception e) throws GalleyMavenXMLException {
        this.logger.debug("Failed to parse: {}. DOM error: {}. Trying STaX parse with IS_REPLACING_ENTITY_REFERENCES == false...", e, docSource, e.getMessage());
        try {
            Source source;
            if (this.safeInputFactory != null) {
                xml = this.repairXmlDeclaration(xml);
                XMLEventReader eventReader = this.safeInputFactory.createXMLEventReader(new StringReader(xml));
                source = new StAXSource(eventReader);
            } else {
                xml = this.escapeNonXMLEntityRefs(xml);
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setFeature("http://xml.org/sax/features/validation", false);
                source = new SAXSource(reader, new InputSource(new StringReader(xml)));
            }
            DOMResult result = new DOMResult();
            Transformer transformer = this.newTransformer();
            transformer.transform(source, result);
            return (Document)result.getNode();
        }
        catch (TransformerException e1) {
            throw new GalleyMavenXMLException("Failed to parse: %s. Transformer error: %s.\nOriginal DOM error: %s", (Throwable)e1, docSource, e1.getMessage(), e.getMessage());
        }
        catch (SAXException e1) {
            throw new GalleyMavenXMLException("Failed to parse: %s. SAX error: %s.\nOriginal DOM error: %s", (Throwable)e1, docSource, e1.getMessage(), e.getMessage());
        }
        catch (XMLStreamException e1) {
            throw new GalleyMavenXMLException("Failed to parse: %s. STaX error: %s.\nOriginal DOM error: %s", (Throwable)e1, docSource, e1.getMessage(), e.getMessage());
        }
    }

    private String repairXmlDeclaration(String xml) {
        if (!xml.startsWith("<?xml")) {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xml;
        }
        return xml;
    }

    private String escapeNonXMLEntityRefs(String xml) {
        Matcher m = Pattern.compile("&([^\\s;]+;)").matcher(xml);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String value = m.group();
            if (!XML_ENTITIES.contains(value)) {
                value = "&amp;" + m.group(1);
            }
            m.appendReplacement(sb, value);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public Document parse(File file) throws GalleyMavenXMLException {
        FileInputStream stream = null;
        Document doc = null;
        try {
            try {
                stream = new FileInputStream(file);
                doc = this.parseDocument(file, stream);
            }
            catch (GalleyMavenXMLException galleyMavenXMLException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            throw new GalleyMavenXMLException("Failed to read: %s. Reason: %s", (Throwable)e, file, e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
        return doc;
    }

    public Document parse(Transfer transfer) throws GalleyMavenXMLException {
        return this.parse(transfer, new EventMetadata());
    }

    public Document parse(Transfer transfer, EventMetadata eventMetadata) throws GalleyMavenXMLException {
        InputStream stream = null;
        Document doc = null;
        try {
            try {
                stream = transfer.openInputStream(false);
                doc = this.parseDocument(transfer.toString(), stream);
            }
            catch (GalleyMavenXMLException galleyMavenXMLException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            try {
                throw new GalleyMavenXMLException("Failed to read: %s. Reason: %s", (Throwable)e, transfer, e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(stream);
        return doc;
    }

    public ProjectVersionRef getProjectVersionRef(Document doc) throws GalleyMavenXMLException {
        Element project = doc.getDocumentElement();
        String gid = this.getChildText("groupId", project);
        String aid = this.getChildText("artifactId", project);
        String ver = this.getChildText("version", project);
        if (StringUtils.isEmpty(gid) || StringUtils.isEmpty(ver)) {
            NodeList nl = project.getElementsByTagName("parent");
            if (nl == null || nl.getLength() < 1) {
                this.logger.debug("No parent declaration.");
                return null;
            }
            Element parent = (Element)nl.item(0);
            gid = this.getChildText("groupId", parent);
            ver = this.getChildText("version", parent);
        }
        if (StringUtils.isEmpty(gid) || StringUtils.isEmpty(aid) || StringUtils.isEmpty(ver)) {
            throw new GalleyMavenXMLException("Project GAV is invalid! (g=%s,  a=%s, v=%s)", gid, aid, ver);
        }
        return new ProjectVersionRef(gid, aid, ver);
    }

    public ProjectVersionRef getParentRef(Document doc) throws GalleyMavenXMLException {
        Element project = doc.getDocumentElement();
        NodeList nl = project.getElementsByTagName("parent");
        if (nl == null || nl.getLength() < 1) {
            this.logger.debug("No parent declaration.");
            return null;
        }
        Element parent = (Element)nl.item(0);
        String gid = this.getChildText("groupId", parent);
        String aid = this.getChildText("artifactId", parent);
        String ver = this.getChildText("version", parent);
        if (StringUtils.isEmpty(gid) || StringUtils.isEmpty(aid) || StringUtils.isEmpty(ver)) {
            throw new GalleyMavenXMLException("Project parent is present but invalid! (g=%s,  a=%s, v=%s)", gid, aid, ver);
        }
        return new ProjectVersionRef(gid, aid, ver);
    }

    private String getChildText(String name, Element parent) {
        NodeList nl = parent.getElementsByTagName(name);
        if (nl == null || nl.getLength() < 1) {
            this.logger.debug("No element: {} in: {}", (Object)name, (Object)parent.getNodeName());
            return null;
        }
        Node elem = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            if (e.getParentNode() != parent) continue;
            elem = e;
            break;
        }
        return elem == null ? null : elem.getTextContent().trim();
    }

    static {
        HashMap<String, String> props = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("org.apache.xml.dtm.DTMManager", "org.apache.xml.dtm.ref.DTMManagerDefault");
                this.put("com.sun.org.apache.xml.internal.dtm.DTMManager", "com.sun.org.apache.xml.internal.dtm.ref.DTMManagerDefault");
            }
        };
        for (Map.Entry entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (System.getProperty(key) != null) continue;
            System.setProperty(key, value);
        }
    }
}

