/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.spi.defaults;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.PluginDependencyView;
import org.commonjava.maven.galley.maven.model.view.PluginView;
import org.commonjava.maven.galley.maven.parse.XMLInfrastructure;
import org.commonjava.maven.galley.maven.spi.defaults.MavenPluginImplications;
import org.w3c.dom.Element;

public abstract class AbstractMavenPluginImplications
implements MavenPluginImplications {
    protected final XMLInfrastructure xml;

    protected AbstractMavenPluginImplications(XMLInfrastructure xml) {
        this.xml = xml;
    }

    protected PluginDependencyView createPluginDependency(PluginView pv, ProjectRef ref) throws GalleyMavenException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("groupId", ref.getGroupId());
        map.put("artifactId", ref.getArtifactId());
        map.put("version", pv.getVersion());
        Element element = pv.getElement();
        return new PluginDependencyView(pv.getPomView(), pv, this.xml.createElement(element, "dependencies/dependency", map));
    }

    @Override
    public Set<PluginDependencyView> getImpliedPluginDependencies(PluginView pv) throws GalleyMavenException {
        ProjectRef ref;
        Map<ProjectRef, Set<ProjectRef>> impliedDepMap = this.getImpliedRefMap();
        Set<ProjectRef> implied = impliedDepMap.get(ref = pv.asProjectRef());
        if (implied == null || implied.isEmpty()) {
            return null;
        }
        HashSet<PluginDependencyView> views = new HashSet<PluginDependencyView>(implied.size());
        for (ProjectRef impliedRef : implied) {
            PluginDependencyView pd = this.createPluginDependency(pv, impliedRef);
            views.add(pd);
        }
        return views;
    }

    protected abstract Map<ProjectRef, Set<ProjectRef>> getImpliedRefMap();
}

