/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.event.FileAccessEvent;
import org.commonjava.maven.galley.event.FileDeletionEvent;
import org.commonjava.maven.galley.event.FileErrorEvent;
import org.commonjava.maven.galley.event.FileStorageEvent;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.spi.cache.CacheProvider;
import org.commonjava.maven.galley.spi.event.FileEventManager;
import org.commonjava.maven.galley.spi.io.TransferDecorator;
import org.commonjava.maven.galley.util.TransferInputStream;
import org.commonjava.maven.galley.util.TransferOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Transfer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcreteResource resource;
    private final CacheProvider provider;
    private final TransferDecorator decorator;
    private final FileEventManager fileEventManager;

    public Transfer(Location loc, CacheProvider provider, FileEventManager fileEventManager, TransferDecorator decorator, String ... path) {
        this.resource = new ConcreteResource(loc, path);
        this.fileEventManager = fileEventManager;
        this.decorator = decorator;
        this.provider = provider;
    }

    public Transfer(ConcreteResource resource, CacheProvider provider, FileEventManager fileEventManager, TransferDecorator decorator) {
        this.resource = resource;
        this.fileEventManager = fileEventManager;
        this.decorator = decorator;
        this.provider = provider;
    }

    public boolean isDirectory() {
        return this.provider.isDirectory(this.resource);
    }

    public boolean isFile() {
        return this.provider.isFile(this.resource);
    }

    public Location getLocation() {
        return this.resource.getLocation();
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public ConcreteResource getResource() {
        return this.resource;
    }

    public String toString() {
        return String.format("%s:%s", this.resource.getLocation(), this.resource.getPath());
    }

    public Transfer getParent() {
        if (this.resource.isRoot()) {
            return this;
        }
        return this.provider.getTransfer((ConcreteResource)this.resource.getParent());
    }

    public Transfer getChild(String file) {
        return this.provider.getTransfer((ConcreteResource)this.resource.getChild(file));
    }

    public void touch() {
        this.touch(new EventMetadata());
    }

    public void touch(EventMetadata eventMetadata) {
        this.provider.waitForWriteUnlock(this.resource);
        if (this.decorator != null) {
            this.decorator.decorateTouch(this);
        }
        this.fileEventManager.fire(new FileAccessEvent(this, eventMetadata));
    }

    public InputStream openInputStream() throws IOException {
        return this.openInputStream(true, new EventMetadata());
    }

    public InputStream openInputStream(boolean fireEvents) throws IOException {
        return this.openInputStream(fireEvents, new EventMetadata());
    }

    public InputStream openInputStream(boolean fireEvents, EventMetadata eventMetadata) throws IOException {
        this.provider.waitForReadUnlock(this.resource);
        try {
            InputStream stream = this.provider.openInputStream(this.resource);
            if (stream == null) {
                return null;
            }
            if (fireEvents) {
                stream = new TransferInputStream(stream, new FileAccessEvent(this, eventMetadata), this.fileEventManager);
            }
            stream = this.decorator == null ? stream : this.decorator.decorateRead(stream, this);
            return stream;
        }
        catch (IOException e) {
            if (fireEvents) {
                this.fileEventManager.fire(new FileErrorEvent(this, e, eventMetadata));
            }
            throw e;
        }
    }

    public OutputStream openOutputStream(TransferOperation accessType) throws IOException {
        return this.openOutputStream(accessType, true, new EventMetadata());
    }

    public OutputStream openOutputStream(TransferOperation accessType, boolean fireEvents) throws IOException {
        return this.openOutputStream(accessType, fireEvents, new EventMetadata());
    }

    public OutputStream openOutputStream(TransferOperation accessType, boolean fireEvents, EventMetadata eventMetadata) throws IOException {
        this.provider.waitForWriteUnlock(this.resource);
        try {
            this.provider.lockWrite(this.resource);
            OutputStream stream = this.provider.openOutputStream(this.resource);
            if (stream == null) {
                return null;
            }
            TransferUnlocker unlocker = new TransferUnlocker(this.resource, this.provider);
            stream = fireEvents ? new TransferOutputStream(stream, unlocker, new FileStorageEvent(accessType, this, eventMetadata), this.fileEventManager) : new TransferOutputStream(stream, unlocker);
            stream = this.decorator == null ? stream : this.decorator.decorateWrite(stream, this, accessType);
            return stream;
        }
        catch (IOException e) {
            if (fireEvents) {
                this.fileEventManager.fire(new FileErrorEvent(this, e, eventMetadata));
            }
            throw e;
        }
    }

    public boolean exists() {
        if (this.decorator != null) {
            this.decorator.decorateExists(this);
        }
        return this.provider.exists(this.resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(Transfer f) throws IOException {
        this.provider.waitForWriteUnlock(this.resource);
        this.provider.lockWrite(this.resource);
        try {
            if (this.decorator != null) {
                this.decorator.decorateCopyFrom(f, this);
            }
            this.provider.copy(f.getResource(), this.resource);
        }
        finally {
            this.provider.unlockWrite(this.resource);
        }
    }

    public String getFullPath() {
        return this.provider.getFilePath(this.resource);
    }

    public boolean delete() throws IOException {
        return this.delete(true, new EventMetadata());
    }

    public boolean delete(boolean fireEvents) throws IOException {
        return this.delete(fireEvents, new EventMetadata());
    }

    public boolean delete(boolean fireEvents, EventMetadata eventMetadata) throws IOException {
        this.provider.waitForWriteUnlock(this.resource);
        try {
            boolean deleted;
            if (this.decorator != null) {
                this.decorator.decorateDelete(this);
            }
            if ((deleted = this.provider.delete(this.resource)) && fireEvents) {
                this.fileEventManager.fire(new FileDeletionEvent(this, eventMetadata));
            }
            return deleted;
        }
        catch (IOException e) {
            if (fireEvents) {
                this.fileEventManager.fire(new FileErrorEvent(this, e, eventMetadata));
            }
            throw e;
        }
    }

    public String[] list() throws IOException {
        String[] listing = this.provider.list(this.resource);
        if (this.decorator != null) {
            listing = this.decorator.decorateListing(this, listing);
        }
        return listing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDetachedFile() {
        this.provider.waitForWriteUnlock(this.resource);
        this.provider.lockWrite(this.resource);
        try {
            File file = this.provider.getDetachedFile(this.resource);
            return file;
        }
        finally {
            this.provider.unlockWrite(this.resource);
        }
    }

    public void mkdirs() throws IOException {
        if (this.decorator != null) {
            this.decorator.decorateMkdirs(this);
        }
        this.provider.mkdirs(this.resource);
    }

    public void createFile() throws IOException {
        this.provider.waitForWriteUnlock(this.resource);
        if (this.decorator != null) {
            this.decorator.decorateCreateFile(this);
        }
        this.provider.createFile(this.resource);
    }

    public long length() {
        return this.provider.length(this.resource);
    }

    public long lastModified() {
        return this.provider.lastModified(this.resource);
    }

    public Transfer getSibling(String named) {
        return this.getParent().getChild(named);
    }

    public Transfer getSiblingMeta(String extension) {
        String named = new File(this.resource.getPath()).getName() + extension;
        this.logger.debug("Creating meta-transfer sibling for: {} with name: {} (parent: {})", this, named, this.getParent());
        return this.getParent().getChild(named);
    }

    public void lockWrite() {
        this.provider.lockWrite(this.resource);
    }

    public void unlock() {
        this.provider.unlockWrite(this.resource);
    }

    public boolean isWriteLocked() {
        return this.provider.isWriteLocked(this.resource);
    }

    public static final class TransferUnlocker {
        private final CacheProvider provider;
        private final ConcreteResource resource;

        private TransferUnlocker(ConcreteResource resource, CacheProvider provider) {
            this.resource = resource;
            this.provider = provider;
        }

        public void unlock() {
            this.provider.unlockWrite(this.resource);
        }
    }
}

