/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Resource;

public class VirtualResource
implements Resource,
Iterable<ConcreteResource> {
    private final List<ConcreteResource> resources;

    public VirtualResource(List<? extends Location> locations, String ... path) {
        ArrayList<ConcreteResource> resources = new ArrayList<ConcreteResource>();
        for (Location location : locations) {
            resources.add(new ConcreteResource(location, path));
        }
        this.resources = resources;
    }

    public VirtualResource(List<ConcreteResource> resources) {
        this.resources = resources;
    }

    public VirtualResource(ConcreteResource ... resources) {
        this.resources = Arrays.asList(resources);
    }

    @Override
    public boolean allowsDownloading() {
        for (ConcreteResource resource : this.resources) {
            if (!resource.allowsDownloading()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowsPublishing() {
        for (ConcreteResource resource : this.resources) {
            if (!resource.allowsPublishing()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowsStoring() {
        for (ConcreteResource resource : this.resources) {
            if (!resource.allowsStoring()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowsSnapshots() {
        for (ConcreteResource resource : this.resources) {
            if (!resource.allowsSnapshots()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowsReleases() {
        for (ConcreteResource resource : this.resources) {
            if (!resource.allowsReleases()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<ConcreteResource> iterator() {
        return this.resources.iterator();
    }

    public List<ConcreteResource> toConcreteResources() {
        return this.resources;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resources == null ? 0 : this.resources.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualResource)) {
            return false;
        }
        VirtualResource other = (VirtualResource)obj;
        return !(this.resources == null ? other.resources != null : !this.resources.equals(other.resources));
    }
}

