/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.nfc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Alternative;
import javax.inject.Named;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.spi.nfc.NotFoundCache;

@Named(value="memory-galley-nfc")
@Alternative
public class MemoryNotFoundCache
implements NotFoundCache {
    private final Map<Location, Set<String>> missing = new HashMap<Location, Set<String>>();

    @Override
    public void addMissing(ConcreteResource resource) {
        Set<String> missing = this.missing.get(resource.getLocation());
        if (missing == null) {
            missing = new HashSet<String>();
            this.missing.put(resource.getLocation(), missing);
        }
        missing.add(resource.getPath());
    }

    @Override
    public boolean isMissing(ConcreteResource resource) {
        Set<String> missing = this.missing.get(resource.getLocation());
        return missing == null ? false : missing.contains(resource.getPath());
    }

    @Override
    public void clearMissing(Location location) {
        this.missing.remove(location);
    }

    @Override
    public void clearMissing(ConcreteResource resource) {
        Set<String> missing = this.missing.get(resource.getLocation());
        if (missing != null) {
            missing.remove(resource.getPath());
        }
    }

    @Override
    public void clearAllMissing() {
        this.missing.clear();
    }

    @Override
    public Map<Location, Set<String>> getAllMissing() {
        return this.missing;
    }

    @Override
    public Set<String> getMissing(Location location) {
        return this.missing.get(location);
    }
}

