/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.inject.Named;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.SimpleLocation;
import org.commonjava.maven.galley.spi.transport.LocationExpander;
import org.commonjava.maven.galley.spi.transport.LocationResolver;
import org.commonjava.maven.galley.spi.transport.Transport;
import org.commonjava.maven.galley.spi.transport.TransportManager;

@Alternative
@Named
public class SimpleUrlLocationResolver
implements LocationResolver {
    @Inject
    private LocationExpander locationExpander;
    @Inject
    private TransportManager transportManager;

    protected SimpleUrlLocationResolver() {
    }

    public SimpleUrlLocationResolver(LocationExpander locationExpander, TransportManager transportManager) {
        this.locationExpander = locationExpander;
        this.transportManager = transportManager;
    }

    @Override
    public final Location resolve(String spec) throws TransferException {
        SimpleLocation location = new SimpleLocation(spec);
        List<Location> locations = this.locationExpander.expand(location);
        if (locations == null || locations.isEmpty()) {
            throw new TransferException("Invalid location: '%s'. Location expansion returned no results.", spec);
        }
        Iterator<Location> iterator = new ArrayList<Location>(locations).iterator();
        while (iterator.hasNext()) {
            Location loc = iterator.next();
            Transport transport = this.transportManager.getTransport(loc);
            if (transport != null) continue;
            iterator.remove();
        }
        if (locations == null || locations.isEmpty()) {
            throw new TransferException("Invalid location: '%s'. No transports available for expanded locations.", spec);
        }
        return location;
    }
}

