/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.transport.htcli.Http;
import org.commonjava.maven.galley.transport.htcli.internal.util.TransferResponseUtils;
import org.commonjava.maven.galley.transport.htcli.model.HttpExchangeMetadata;
import org.commonjava.maven.galley.transport.htcli.model.HttpLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpJob {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String url;
    protected final HttpLocation location;
    protected final Http http;
    protected TransferException error;
    protected HttpUriRequest request;
    protected CloseableHttpClient client;
    protected CloseableHttpResponse response;
    private final Collection<Integer> successStatuses;
    protected boolean success;

    protected AbstractHttpJob(String url, HttpLocation location, Http http, Integer ... successStatuses) {
        this.url = url;
        this.location = location;
        this.http = http;
        this.successStatuses = successStatuses.length < 1 ? Collections.singleton(200) : Arrays.asList(successStatuses);
    }

    public TransferException getError() {
        return this.error;
    }

    protected boolean executeHttp() throws TransferException {
        try {
            this.client = this.http.createClient(this.location);
            this.response = this.client.execute(this.request, this.http.createContext(this.location));
            StatusLine line = this.response.getStatusLine();
            int sc = line.getStatusCode();
            this.logger.debug("HEAD {} : {}", (Object)line, (Object)this.url);
            if (!this.successStatuses.contains(sc)) {
                this.logger.debug("Detected failure response: " + sc);
                this.success = TransferResponseUtils.handleUnsuccessfulResponse(this.request, this.response, this.url);
                this.logger.debug("Returning non-error failure response for code: " + sc);
                return false;
            }
        }
        catch (ClientProtocolException e) {
            throw new TransferException("Repository remote request failed for: {}. Reason: {}", (Throwable)e, this.url, e.getMessage());
        }
        catch (IOException e) {
            throw new TransferException("Repository remote request failed for: {}. Reason: {}", (Throwable)e, this.url, e.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMetadata(Transfer target, final ObjectMapper mapper) {
        if (this.request == null || this.response == null) {
            this.logger.debug("Cannot write HTTP exchange metadata. Request: {}. Response: {}", (Object)this.request, (Object)this.response);
            return;
        }
        this.logger.debug("Writing HTTP exchange metadata. Request: {}. Response: {}", (Object)this.request, (Object)this.response);
        Transfer metaTxfr = target.getSiblingMeta(".http-metadata.json");
        final HttpExchangeMetadata metadata = new HttpExchangeMetadata(this.request, this.response);
        OutputStream out = null;
        try {
            out = metaTxfr.openOutputStream(TransferOperation.GENERATE, false);
            this.logger.debug("Writing HTTP exchange metadata:\n\n{}\n\n", new Object(){

                public String toString() {
                    try {
                        return mapper.writeValueAsString(metadata);
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        return "ERROR RENDERING METADATA";
                    }
                }
            });
            out.write(mapper.writeValueAsBytes(metadata));
        }
        catch (IOException e) {
            block6: {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(String.format("Failed to write metadata for HTTP exchange to: %s. Reason: %s", metaTxfr, e.getMessage()), e);
                        break block6;
                    }
                    this.logger.warn("Failed to write metadata for HTTP exchange to: {}. Reason: {}", (Object)metaTxfr, (Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(out);
        }
        IOUtils.closeQuietly(out);
    }

    protected void cleanup() {
        this.http.cleanup(this.client, this.request, this.response);
        this.client = null;
        this.request = null;
        this.response = null;
    }
}

