/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.ListingResult;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.spi.transport.ListingJob;
import org.commonjava.maven.galley.transport.htcli.Http;
import org.commonjava.maven.galley.transport.htcli.internal.AbstractHttpJob;
import org.commonjava.maven.galley.transport.htcli.model.HttpLocation;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class HttpListing
extends AbstractHttpJob
implements ListingJob {
    private static final Set<String> EXCLUDES = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("../");
        }
    };
    private final ConcreteResource resource;
    private final Transfer target;

    public HttpListing(String url, ConcreteResource resource, int timeoutSeconds, Transfer target, Http http) {
        super(url, (HttpLocation)resource.getLocation(), http, new Integer[0]);
        this.resource = resource;
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListingResult call() {
        this.request = new HttpGet(this.url);
        ListingResult result = null;
        OutputStream stream = null;
        try {
            if (this.executeHttp()) {
                InputStream in = this.response.getEntity().getContent();
                ArrayList<String> al = new ArrayList<String>();
                Document doc = Jsoup.parse(in, "UTF-8", this.url);
                for (Element file : doc.select("a")) {
                    if (!file.attr("href").contains(file.text()) || EXCLUDES.contains(file.text())) continue;
                    al.add(file.text());
                }
                stream = this.target.openOutputStream(TransferOperation.DOWNLOAD);
                stream.write(StringUtils.join(al, "\n").getBytes("UTF-8"));
                result = new ListingResult(this.resource, al.toArray(new String[al.size()]));
            }
        }
        catch (TransferException e) {
            this.error = e;
        }
        catch (IOException e) {
            this.error = new TransferException("Failed to parse directory listing HTML for: {} using JSoup. Reason: {}", (Throwable)e, this.url, e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(stream);
            this.cleanup();
        }
        return this.error == null ? result : null;
    }
}

