/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.internal;

import java.io.InputStream;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.spi.transport.PublishJob;
import org.commonjava.maven.galley.transport.htcli.Http;
import org.commonjava.maven.galley.transport.htcli.internal.AbstractHttpJob;
import org.commonjava.maven.galley.transport.htcli.model.HttpLocation;
import org.commonjava.maven.galley.util.ContentTypeUtils;

public final class HttpPublish
extends AbstractHttpJob
implements PublishJob {
    private final InputStream stream;
    private final long length;
    private final String contentType;
    private boolean success;

    public HttpPublish(String url, HttpLocation location, InputStream stream, long length, String contentType, Http http) {
        super(url, location, http, 200, 201);
        this.stream = stream;
        this.length = length;
        this.contentType = contentType == null ? ContentTypeUtils.detectContent(url) : contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpPublish call() {
        HttpPut put = new HttpPut(this.url);
        put.setEntity(new InputStreamEntity(this.stream, this.length, ContentType.create(this.contentType)));
        this.request = put;
        try {
            this.success = this.executeHttp();
        }
        catch (TransferException e) {
            this.error = e;
        }
        finally {
            this.cleanup();
        }
        return this;
    }

    @Override
    public boolean isSuccessful() {
        return this.success;
    }
}

