/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.internal.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.transport.htcli.conf.GlobalHttpConfiguration;
import org.commonjava.maven.galley.transport.htcli.conf.ProxyConfig;
import org.commonjava.maven.galley.transport.htcli.model.HttpLocation;

public class WrapperHttpLocation
implements HttpLocation {
    private final Location delegate;
    private final URL url;
    private final GlobalHttpConfiguration globalConfig;

    public WrapperHttpLocation(Location delegate, GlobalHttpConfiguration globalConfig) throws MalformedURLException {
        this.delegate = delegate;
        this.globalConfig = globalConfig;
        this.url = new URL(delegate.getUri());
    }

    @Override
    public boolean allowsSnapshots() {
        return this.delegate.allowsSnapshots();
    }

    @Override
    public boolean allowsReleases() {
        return this.delegate.allowsReleases();
    }

    @Override
    public String getUri() {
        return this.delegate.getUri();
    }

    @Override
    public String getKeyCertPem() {
        return null;
    }

    @Override
    public String getServerCertPem() {
        return null;
    }

    @Override
    public String getHost() {
        return this.url.getHost();
    }

    @Override
    public int getPort() {
        return this.url.getPort() < 0 ? this.url.getDefaultPort() : this.url.getPort();
    }

    @Override
    public String getUser() {
        int idx;
        String userpass = this.url.getUserInfo();
        if (userpass != null && (idx = userpass.indexOf(":")) > -1) {
            return userpass.substring(0, idx);
        }
        return userpass;
    }

    @Override
    public String getProxyHost() {
        ProxyConfig proxy = this.globalConfig == null ? null : this.globalConfig.getProxyConfig(this.url);
        return proxy == null ? null : proxy.getHost();
    }

    @Override
    public String getProxyUser() {
        ProxyConfig proxy = this.globalConfig == null ? null : this.globalConfig.getProxyConfig(this.url);
        return proxy == null ? null : proxy.getUser();
    }

    @Override
    public int getProxyPort() {
        ProxyConfig proxy = this.globalConfig == null ? null : this.globalConfig.getProxyConfig(this.url);
        return proxy == null ? 8080 : proxy.getPort();
    }

    @Override
    public boolean equals(Object other) {
        return this.delegate.equals(other);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.delegate.getAttributes();
    }

    @Override
    public <T> T getAttribute(String key, Class<T> type) {
        return this.delegate.getAttribute(key, type);
    }

    @Override
    public <T> T getAttribute(String key, Class<T> type, T defaultValue) {
        return this.delegate.getAttribute(key, type, defaultValue);
    }

    @Override
    public Object removeAttribute(String key) {
        return this.delegate.removeAttribute(key);
    }

    @Override
    public Object setAttribute(String key, Object value) {
        return this.delegate.setAttribute(key, value);
    }

    @Override
    public boolean allowsPublishing() {
        return this.delegate.allowsPublishing();
    }

    @Override
    public boolean allowsStoring() {
        return this.delegate.allowsStoring();
    }

    @Override
    public boolean allowsDownloading() {
        return true;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }
}

