/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

public class HttpExchangeMetadata {
    public static final String FILE_EXTENSION = ".http-metadata.json";
    private static final String LAST_MODIFIED = "LAST-MODIFIED";
    private static final Object CONTENT_LENGTH = "CONTENT-LENGTH";
    private Map<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
    private Map<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
    private String responseStatusMessage;
    private int responseStatusCode;

    public HttpExchangeMetadata() {
    }

    public HttpExchangeMetadata(HttpRequest request, HttpResponse response) {
        this.populateHeaders(this.requestHeaders, request.getAllHeaders());
        this.populateHeaders(this.responseHeaders, response.getAllHeaders());
        StatusLine sl = response.getStatusLine();
        this.responseStatusCode = sl.getStatusCode();
        this.responseStatusMessage = sl.getReasonPhrase();
    }

    private void populateHeaders(Map<String, List<String>> headerMap, Header[] allHeaders) {
        for (Header header : allHeaders) {
            List<String> values = headerMap.get(header.getName());
            if (values == null) {
                values = new ArrayList<String>();
                headerMap.put(header.getName().toUpperCase(), values);
            }
            values.add(header.getValue());
        }
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(Map<String, List<String>> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, List<String>> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public String getResponseStatusMessage() {
        return this.responseStatusMessage;
    }

    public void setResponseStatusMessage(String responseStatusMessage) {
        this.responseStatusMessage = responseStatusMessage;
    }

    public int getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public void setResponseStatusCode(int responseStatusCode) {
        this.responseStatusCode = responseStatusCode;
    }

    public String getLastModified() {
        List<String> values = this.responseHeaders.get(LAST_MODIFIED);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public Long getContentLength() {
        List<String> values = this.responseHeaders.get(CONTENT_LENGTH);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return Long.parseLong(values.get(0));
    }
}

