/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicFileOutputStreamWrapper
extends FilterOutputStream {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final File downloadFile;
    private final File targetFile;
    private final AtomicStreamCallbacks callbacks;

    public AtomicFileOutputStreamWrapper(File targetFile, File downloadFile, OutputStream stream) throws FileNotFoundException {
        super(stream);
        this.targetFile = targetFile;
        this.downloadFile = downloadFile;
        this.callbacks = null;
    }

    public AtomicFileOutputStreamWrapper(File targetFile, File downloadFile, OutputStream stream, AtomicStreamCallbacks callbacks) throws FileNotFoundException {
        super(stream);
        this.targetFile = targetFile;
        this.downloadFile = downloadFile;
        this.callbacks = callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.callbacks != null) {
            this.callbacks.beforeClose();
        }
        try {
            super.close();
        }
        catch (Throwable throwable) {
            try {
                this.downloadFile.renameTo(this.targetFile);
            }
            catch (Exception e) {
                this.logger.error(String.format("Failed to rename: %s to: %s", this.downloadFile, this.targetFile), e);
            }
            if (this.callbacks != null) {
                this.callbacks.afterClose();
            }
            throw throwable;
        }
        try {
            this.downloadFile.renameTo(this.targetFile);
        }
        catch (Exception e) {
            this.logger.error(String.format("Failed to rename: %s to: %s", this.downloadFile, this.targetFile), e);
        }
        if (this.callbacks != null) {
            this.callbacks.afterClose();
        }
    }

    public static abstract class AtomicStreamCallbacks {
        public void beforeClose() {
        }

        public void afterClose() {
        }
    }
}

