/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.containers;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Providers;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import org.sonatype.guice.bean.binders.WireModule;
import org.sonatype.guice.bean.locators.BeanLocator;
import org.sonatype.guice.bean.reflect.Logs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SisuGuice {
    private static final ThreadLocal<BeanLocator> LOCATOR = new InheritableThreadLocal<BeanLocator>();
    private static volatile BeanLocator latest;

    private SisuGuice() {
    }

    @Inject
    public static void setBeanLocator(BeanLocator locator) {
        if (null != locator) {
            LOCATOR.set(locator);
        } else {
            LOCATOR.remove();
        }
        latest = locator;
    }

    public static BeanLocator getBeanLocator() {
        BeanLocator locator = LOCATOR.get();
        return null != locator ? locator : latest;
    }

    public static <T> T lookup(Key<T> key) {
        BeanLocator locator = SisuGuice.getBeanLocator();
        if (null != locator) {
            Iterator i = locator.locate(key).iterator();
            if (i.hasNext()) {
                return (T)((Map.Entry)i.next()).getValue();
            }
        } else {
            Logs.debug("No BeanLocator found for thread {}", Thread.currentThread(), null);
        }
        return null;
    }

    public static void inject(final Object that) {
        final BeanLocator locator = SisuGuice.getBeanLocator();
        if (null != locator) {
            Guice.createInjector(new WireModule(new Module[0]){

                public void configure(Binder binder) {
                    binder.bind(BeanLocator.class).toProvider(Providers.of(locator));
                    binder.requestInjection(that);
                }
            });
        } else {
            Logs.debug("No BeanLocator found for thread {}", Thread.currentThread(), null);
        }
    }

    public static Injector enhance(final Injector injector) {
        Class[] api = new Class[]{Injector.class};
        return (Injector)Proxy.newProxyInstance(api[0].getClassLoader(), api, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
                String methodName = method.getName();
                if ("getInstance".equals(methodName)) {
                    Key key = args[0] instanceof Key ? (Key)args[0] : Key.get((Class)args[0]);
                    Iterator i = injector.getInstance(BeanLocator.class).locate(key).iterator();
                    return i.hasNext() ? ((Map.Entry)i.next()).getValue() : null;
                }
                if ("injectMembers".equals(methodName)) {
                    Guice.createInjector(new WireModule(new Module(){

                        public void configure(Binder binder) {
                            binder.bind(BeanLocator.class).toProvider(injector.getProvider(BeanLocator.class));
                            binder.requestInjection(args[0]);
                        }
                    }));
                    return null;
                }
                return method.invoke((Object)injector, args);
            }
        });
    }
}

