/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.VersionlessArtifactRef;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.ManipulationSession;
import org.commonjava.maven.ext.manip.impl.Manipulator;
import org.commonjava.maven.ext.manip.io.ModelIO;
import org.commonjava.maven.ext.manip.model.Project;
import org.commonjava.maven.ext.manip.state.DependencyState;
import org.commonjava.maven.ext.manip.state.State;
import org.commonjava.maven.ext.manip.util.IdUtils;
import org.commonjava.maven.ext.manip.util.PropertiesUtils;
import org.commonjava.maven.ext.manip.util.WildcardMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=Manipulator.class, hint="project-dependency-manipulator")
public class DependencyManipulator
implements Manipulator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Requirement
    protected ModelIO effectiveModelBuilder;

    @Override
    public void init(ManipulationSession session) {
        Properties userProps = session.getUserProperties();
        session.setState(new DependencyState(userProps));
    }

    @Override
    public void scan(List<Project> projects, ManipulationSession session) throws ManipulationException {
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects, ManipulationSession session) throws ManipulationException {
        DependencyState state = session.getState(DependencyState.class);
        if (!session.isEnabled() || !state.isEnabled()) {
            this.logger.debug(this.getClass().getSimpleName() + ": Nothing to do!");
            return Collections.emptySet();
        }
        HashSet<Project> result = new HashSet<Project>();
        boolean strict = state.getStrict();
        HashMap<String, String> versionPropertyUpdateMap = state.getVersionPropertyUpdateMap();
        Map<ProjectRef, String> overrides = this.loadRemoteBOM(state, session);
        for (Project project : projects) {
            Model model = project.getModel();
            if (overrides.size() <= 0) continue;
            this.apply(session, project, model, overrides);
            result.add(project);
        }
        if (result.size() > 0) {
            for (String key : versionPropertyUpdateMap.keySet()) {
                boolean found = false;
                for (Project p : result) {
                    if (!p.getModel().getProperties().containsKey(key)) continue;
                    this.logger.info("Updating property {} with {} ", (Object)key, versionPropertyUpdateMap.get(key));
                    String oldValue = p.getModel().getProperties().getProperty(key);
                    String overrideVersion = (String)versionPropertyUpdateMap.get(key);
                    found = true;
                    if (strict && oldValue != null && !overrideVersion.startsWith(oldValue)) {
                        if (state.getFailOnStrictViolation()) {
                            throw new ManipulationException("Replacement: {} of original version: {} in property: {} violates the strict version-alignment rule!", overrideVersion, oldValue, key);
                        }
                        this.logger.warn("Replacement: {} of original version: {} in property: {} violates the strict version-alignment rule!", new Object[]{overrideVersion, oldValue, key});
                        continue;
                    }
                    p.getModel().getProperties().setProperty(key, (String)versionPropertyUpdateMap.get(key));
                }
                if (found) continue;
                this.logger.info("Unable to find a property for {} to update", (Object)key);
                for (Project p : result) {
                    if (!p.isInheritanceRoot()) continue;
                    this.logger.info("Adding property {} with {} ", (Object)key, versionPropertyUpdateMap.get(key));
                    p.getModel().getProperties().setProperty(key, (String)versionPropertyUpdateMap.get(key));
                }
            }
        }
        return result;
    }

    private Map<ProjectRef, String> loadRemoteBOM(State state, ManipulationSession session) throws ManipulationException {
        LinkedHashMap<ProjectRef, String> overrides = new LinkedHashMap<ProjectRef, String>();
        List<ProjectVersionRef> gavs = ((DependencyState)state).getRemoteDepMgmt();
        if (gavs == null || gavs.isEmpty()) {
            return overrides;
        }
        ListIterator<ProjectVersionRef> iter = gavs.listIterator(gavs.size());
        while (iter.hasPrevious()) {
            ProjectVersionRef ref = iter.previous();
            overrides.putAll(this.effectiveModelBuilder.getRemoteDependencyVersionOverrides(ref, session));
        }
        return overrides;
    }

    private void apply(ManipulationSession session, Project project, Model model, Map<ProjectRef, String> overrides) throws ManipulationException {
        DependencyManagement dependencyManagement;
        WildcardMap explicitOverrides = new WildcardMap();
        DependencyState state = session.getState(DependencyState.class);
        HashMap<String, String> versionPropertyUpdateMap = state.getVersionPropertyUpdateMap();
        String projectGA = IdUtils.ga(project);
        Map<String, String> moduleOverrides = new LinkedHashMap<String, String>();
        for (ProjectRef var : overrides.keySet()) {
            moduleOverrides.put(var.asProjectRef().toString(), overrides.get(var));
        }
        this.logger.debug("Adding in dependency-exclusion properties...");
        moduleOverrides.putAll(PropertiesUtils.getPropertiesByPrefix(session.getUserProperties(), "dependencyExclusion."));
        moduleOverrides = this.removeReactorGAs(session, moduleOverrides);
        try {
            moduleOverrides = this.applyModuleVersionOverrides(projectGA, moduleOverrides, explicitOverrides);
        }
        catch (InvalidRefException e) {
            this.logger.error("Invalid module exclusion override {} : {} ", moduleOverrides, (Object)explicitOverrides);
            throw e;
        }
        if (project.isInheritanceRoot()) {
            if (project.getParent() != null && moduleOverrides.containsKey(IdUtils.ga(project.getParent()))) {
                this.logger.debug(" Modifying parent reference from {} to {}", (Object)model.getParent().getVersion(), (Object)moduleOverrides.get(IdUtils.ga(project.getParent())));
                model.getParent().setVersion(moduleOverrides.get(IdUtils.ga(project.getParent())));
            }
            if (session.getState(DependencyState.class).getOverrideDependencies()) {
                dependencyManagement = model.getDependencyManagement();
                if (dependencyManagement == null) {
                    dependencyManagement = new DependencyManagement();
                    model.setDependencyManagement(dependencyManagement);
                    this.logger.debug("Added <DependencyManagement/> for current project");
                }
                List dependencies = dependencyManagement.getDependencies();
                this.logger.debug("Applying overrides to managed dependencies for top-pom: {}\n{}", (Object)projectGA, moduleOverrides);
                Map<String, String> nonMatchingVersionOverrides = this.applyOverrides(session, project, dependencies, moduleOverrides);
                LinkedHashMap<String, String> matchedOverrides = new LinkedHashMap<String, String>(moduleOverrides);
                matchedOverrides.keySet().removeAll(nonMatchingVersionOverrides.keySet());
                this.applyExplicitOverrides(versionPropertyUpdateMap, explicitOverrides, dependencies);
                this.addVersionOverrideProperties(session, matchedOverrides, model.getProperties());
                if (session.getState(DependencyState.class).getOverrideTransitive()) {
                    ArrayList<Dependency> extraDeps = new ArrayList<Dependency>();
                    for (ProjectRef projectRef : overrides.keySet()) {
                        VersionlessArtifactRef var = (VersionlessArtifactRef)projectRef;
                        if (!nonMatchingVersionOverrides.containsKey(var.asProjectRef().toString())) continue;
                        Dependency newDependency = new Dependency();
                        newDependency.setGroupId(var.getGroupId());
                        newDependency.setArtifactId(var.getArtifactId());
                        newDependency.setType(var.getType());
                        newDependency.setClassifier(var.getClassifier());
                        if (var.isOptional()) {
                            newDependency.setOptional(var.isOptional());
                        }
                        String artifactVersion = moduleOverrides.get(var.asProjectRef().toString());
                        newDependency.setVersion(artifactVersion);
                        extraDeps.add(newDependency);
                        this.logger.debug("New entry added to <DependencyManagement/> - {} : {} ", (Object)projectRef, (Object)artifactVersion);
                        this.addVersionOverrideProperties(session, nonMatchingVersionOverrides, model.getProperties());
                    }
                    dependencyManagement.getDependencies().addAll(0, extraDeps);
                } else {
                    this.logger.debug("Non-matching dependencies ignored.");
                }
            } else {
                this.logger.debug("NOT applying overrides to managed dependencies for Top-pom: {}\n{}", (Object)projectGA, moduleOverrides);
            }
        } else {
            dependencyManagement = model.getDependencyManagement();
            if (session.getState(DependencyState.class).getOverrideDependencies() && dependencyManagement != null) {
                this.logger.debug("Applying overrides to managed dependencies for: {}\n{}", (Object)projectGA, moduleOverrides);
                this.applyOverrides(session, project, dependencyManagement.getDependencies(), moduleOverrides);
                this.applyExplicitOverrides(versionPropertyUpdateMap, explicitOverrides, dependencyManagement.getDependencies());
            } else {
                this.logger.debug("NOT applying overrides to managed dependencies for: {}\n{}", (Object)projectGA, moduleOverrides);
            }
        }
        if (session.getState(DependencyState.class).getOverrideDependencies()) {
            this.logger.debug("Applying overrides to concrete dependencies for: {}\n{}", (Object)projectGA, moduleOverrides);
            List projectDependencies = model.getDependencies();
            this.applyOverrides(session, project, projectDependencies, moduleOverrides);
            this.applyExplicitOverrides(versionPropertyUpdateMap, explicitOverrides, projectDependencies);
        } else {
            this.logger.debug("NOT applying overrides to concrete dependencies for: {}\n{}", (Object)projectGA, moduleOverrides);
        }
    }

    private void applyExplicitOverrides(Map<String, String> versionPropertyUpdateMap, WildcardMap explicitOverrides, List<Dependency> dependencies) throws ManipulationException {
        for (Dependency dependency : dependencies) {
            ProjectRef groupIdArtifactId = new ProjectRef(dependency.getGroupId(), dependency.getArtifactId());
            if (!explicitOverrides.containsKey(groupIdArtifactId)) continue;
            String overrideVersion = explicitOverrides.get(groupIdArtifactId);
            String oldVersion = dependency.getVersion();
            if (overrideVersion == null || overrideVersion.length() == 0 || oldVersion == null || oldVersion.length() == 0) {
                if (oldVersion == null || oldVersion.length() == 0) {
                    this.logger.warn("Unable to force align as no existing version field to update for " + groupIdArtifactId + "; ignoring");
                    continue;
                }
                this.logger.warn("Unable to force align as override version is empty for " + groupIdArtifactId + "; ignoring");
                continue;
            }
            this.logger.debug("Force aligning {} to {}.", (Object)groupIdArtifactId, (Object)overrideVersion);
            if (oldVersion.startsWith("${")) {
                int endIndex = oldVersion.indexOf(125);
                String oldProperty = oldVersion.substring(2, endIndex);
                if (endIndex != oldVersion.length() - 1) {
                    throw new ManipulationException("NYI : handling for versions (" + oldVersion + ") with multiple embedded properties is NYI. ", new String[0]);
                }
                this.logger.debug("Original version was a property mapping; caching new fixed value for update {} -> {}", (Object)oldProperty, (Object)overrideVersion);
                String oldVersionProp = oldVersion.substring(2, oldVersion.length() - 1);
                versionPropertyUpdateMap.put(oldVersionProp, overrideVersion);
                continue;
            }
            dependency.setVersion(overrideVersion);
        }
    }

    private Map<String, String> applyOverrides(ManipulationSession session, Project project, List<Dependency> dependencies, Map<String, String> overrides) throws ManipulationException {
        LinkedHashMap<String, String> unmatchedVersionOverrides = new LinkedHashMap<String, String>();
        unmatchedVersionOverrides.putAll(overrides);
        if (dependencies == null) {
            return unmatchedVersionOverrides;
        }
        DependencyState state = session.getState(DependencyState.class);
        HashMap<String, String> versionPropertyUpdateMap = state.getVersionPropertyUpdateMap();
        boolean strict = state.getStrict();
        for (Dependency dependency : dependencies) {
            String groupIdArtifactId = IdUtils.ga(dependency.getGroupId(), dependency.getArtifactId());
            if (!overrides.containsKey(groupIdArtifactId)) continue;
            String oldVersion = dependency.getVersion();
            String overrideVersion = overrides.get(groupIdArtifactId);
            if (overrideVersion == null || overrideVersion.length() == 0 || oldVersion == null || oldVersion.length() == 0) {
                this.logger.warn("Unable to align to an empty version for " + groupIdArtifactId + "; ignoring");
                continue;
            }
            if (oldVersion.startsWith("${")) {
                int endIndex = oldVersion.indexOf(125);
                String oldProperty = oldVersion.substring(2, endIndex);
                if (endIndex != oldVersion.length() - 1) {
                    throw new ManipulationException("NYI : handling for versions (" + oldVersion + ") with multiple embedded properties is NYI. ", new String[0]);
                }
                this.logger.debug("Original version was a property mapping; caching new value for update {} -> {}", (Object)oldProperty, (Object)overrideVersion);
                String oldVersionProp = oldVersion.substring(2, oldVersion.length() - 1);
                versionPropertyUpdateMap.put(oldVersionProp, overrideVersion);
            } else if (strict && !overrideVersion.startsWith(oldVersion)) {
                if (state.getFailOnStrictViolation()) {
                    throw new ManipulationException("Replacement: {} of original version: {} in dependency: {} violates the strict version-alignment rule!", overrideVersion, oldVersion, groupIdArtifactId);
                }
                this.logger.warn("Replacement: {} of original version: {} in dependency: {} violates the strict version-alignment rule!", new Object[]{overrideVersion, oldVersion, groupIdArtifactId});
            } else {
                this.logger.debug("Altered dependency {} {} -> {}", new Object[]{groupIdArtifactId, oldVersion, overrideVersion});
                dependency.setVersion(overrideVersion);
            }
            unmatchedVersionOverrides.remove(groupIdArtifactId);
        }
        return unmatchedVersionOverrides;
    }

    private Map<String, String> removeReactorGAs(ManipulationSession session, Map<String, String> versionOverrides) {
        LinkedHashMap<String, String> reducedVersionOverrides = new LinkedHashMap<String, String>(versionOverrides);
        for (Project project : session.getProjects()) {
            String reactorGA = IdUtils.ga(project.getModel());
            reducedVersionOverrides.remove(reactorGA);
        }
        return reducedVersionOverrides;
    }

    private Map<String, String> applyModuleVersionOverrides(String projectGA, Map<String, String> originalOverrides, WildcardMap explicitOverrides) throws ManipulationException {
        LinkedHashMap<String, String> remainingOverrides = new LinkedHashMap<String, String>(originalOverrides);
        this.logger.debug("Calculating module-specific version overrides. Starting with:\n  {}", (Object)StringUtils.join(remainingOverrides.entrySet(), (String)"\n  "));
        LinkedHashMap<String, String> moduleVersionOverrides = new LinkedHashMap<String, String>();
        HashSet<String> processedKeys = new HashSet<String>();
        boolean[] wildcardMode = new boolean[]{false, true};
        for (int i = 0; i < wildcardMode.length; ++i) {
            for (String currentKey : new HashSet(remainingOverrides.keySet())) {
                this.logger.debug("Processing key for override: {}", (Object)currentKey);
                if (!currentKey.contains("@")) {
                    this.logger.debug("Not an override. Skip.");
                    continue;
                }
                processedKeys.add(currentKey);
                String currentValue = (String)remainingOverrides.get(currentKey);
                boolean isWildcard = currentKey.endsWith("@*");
                this.logger.debug("Is wildcard? {}", (Object)isWildcard);
                if (!wildcardMode[i]) {
                    if (isWildcard) {
                        this.logger.debug("Not currently in wildcard mode. Skip.");
                        continue;
                    }
                    String[] artifactAndModule = currentKey.split("@");
                    if (artifactAndModule.length != 2) {
                        throw new ManipulationException("Invalid format for exclusion key " + currentKey, new String[0]);
                    }
                    String artifactGA = artifactAndModule[0];
                    String moduleGA = artifactAndModule[1];
                    this.logger.debug("For artifact override: {}, comparing parsed module: {} to current project: {}", new Object[]{artifactGA, moduleGA, projectGA});
                    if (!moduleGA.equals(projectGA)) continue;
                    if (currentValue != null && currentValue.length() > 0) {
                        explicitOverrides.put(ProjectRef.parse((String)artifactGA), currentValue);
                        this.logger.debug("Overriding module dependency for {} with {} : {}", new Object[]{moduleGA, artifactGA, currentValue});
                        continue;
                    }
                    remainingOverrides.remove(artifactGA);
                    this.logger.debug("Ignoring module dependency override for {} " + moduleGA);
                    continue;
                }
                if (!isWildcard) {
                    this.logger.debug("Currently in wildcard mode. Skip.");
                    continue;
                }
                String artifactGA = currentKey.substring(0, currentKey.length() - 2);
                this.logger.debug("For artifact override: {}, checking if current overrides already contain a module-specific version.", (Object)artifactGA);
                if (explicitOverrides.containsKey(ProjectRef.parse((String)artifactGA))) {
                    this.logger.debug("For artifact override: {}, current overrides already contain a module-specific version. Skip.", (Object)artifactGA);
                    continue;
                }
                if (currentValue != null && currentValue.length() > 0) {
                    this.logger.debug("Overriding module dependency for {} with {} : {}", new Object[]{projectGA, artifactGA, currentValue});
                    explicitOverrides.put(ProjectRef.parse((String)artifactGA), currentValue);
                    continue;
                }
                if (artifactGA.endsWith(":*")) {
                    ProjectRef artifactGAPr = ProjectRef.parse((String)artifactGA);
                    Iterator it = remainingOverrides.keySet().iterator();
                    while (it.hasNext()) {
                        ProjectRef pr = ProjectRef.parse((String)((String)it.next()));
                        if (!artifactGAPr.getGroupId().equals(pr.getGroupId())) continue;
                        this.logger.debug("Removing artifactGA " + pr + " from overrides");
                        it.remove();
                    }
                } else {
                    remainingOverrides.remove(artifactGA);
                    this.logger.debug("Removing artifactGA " + artifactGA + " from overrides");
                }
                this.logger.debug("Ignoring module dependency override for {} " + projectGA);
            }
        }
        for (Map.Entry entry : remainingOverrides.entrySet()) {
            String key = (String)entry.getKey();
            if (processedKeys.contains(key) || moduleVersionOverrides.containsKey(key)) continue;
            String value = (String)entry.getValue();
            this.logger.debug("back-filling with override from original map: '{}' = '{}'", (Object)key, (Object)value);
            moduleVersionOverrides.put(key, value);
        }
        this.logger.debug("Returning module-specific overrides:\n{}", (Object)StringUtils.join(moduleVersionOverrides.entrySet(), (String)"\n  "));
        return moduleVersionOverrides;
    }

    private void addVersionOverrideProperties(ManipulationSession session, Map<String, String> overrides, Properties props) {
        Properties properties = session.getUserProperties();
        DependencyState.VersionPropertyFormat result = DependencyState.VersionPropertyFormat.VG;
        switch (DependencyState.VersionPropertyFormat.valueOf(properties.getProperty("versionPropertyFormat", DependencyState.VersionPropertyFormat.NONE.toString()).toUpperCase())) {
            case VG: {
                result = DependencyState.VersionPropertyFormat.VG;
                break;
            }
            case VGA: {
                result = DependencyState.VersionPropertyFormat.VGA;
                break;
            }
            case NONE: {
                result = DependencyState.VersionPropertyFormat.NONE;
                return;
            }
        }
        for (String currentGA : overrides.keySet()) {
            String versionPropName = "version." + (result == DependencyState.VersionPropertyFormat.VGA ? currentGA.replace(":", ".") : currentGA.split(":")[0]);
            this.logger.debug("Adding version override property for {} of {}:{}", new Object[]{currentGA, versionPropName, overrides.get(currentGA)});
            props.setProperty(versionPropName, overrides.get(currentGA));
        }
    }

    @Override
    public int getExecutionIndex() {
        return 40;
    }
}

