/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.ManipulationSession;
import org.commonjava.maven.ext.manip.impl.Manipulator;
import org.commonjava.maven.ext.manip.model.Project;
import org.commonjava.maven.ext.manip.resolver.GalleyAPIWrapper;
import org.commonjava.maven.ext.manip.state.DistributionEnforcingState;
import org.commonjava.maven.ext.manip.state.EnforcingMode;
import org.commonjava.maven.ext.manip.util.IdUtils;
import org.commonjava.maven.ext.manip.util.PropertiesUtils;
import org.commonjava.maven.galley.maven.parse.GalleyMavenXMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=Manipulator.class, hint="enforce-skip")
public class DistributionEnforcingManipulator
implements Manipulator {
    public static final String MAVEN_PLUGIN_GROUPID = "org.apache.maven.plugins";
    public static final String MAVEN_INSTALL_ARTIFACTID = "maven-install-plugin";
    public static final String MAVEN_DEPLOY_ARTIFACTID = "maven-deploy-plugin";
    public static final String SKIP_NODE = "skip";
    public static final String DEFAULT_INSTALL_EXEC = "default-install";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Requirement
    protected GalleyAPIWrapper galleyWrapper;

    protected DistributionEnforcingManipulator() {
    }

    public DistributionEnforcingManipulator(GalleyAPIWrapper galleyWrapper) {
        this.galleyWrapper = galleyWrapper;
    }

    @Override
    public void init(ManipulationSession session) throws ManipulationException {
        session.setState(new DistributionEnforcingState(session.getUserProperties()));
    }

    @Override
    public void scan(List<Project> projects, ManipulationSession session) throws ManipulationException {
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects, ManipulationSession session) throws ManipulationException {
        DistributionEnforcingState state = session.getState(DistributionEnforcingState.class);
        if (state == null || !state.isEnabled()) {
            this.logger.debug("Distribution skip-flag enforcement is disabled.");
            return Collections.emptySet();
        }
        Map<String, String> excluded = PropertiesUtils.getPropertiesByPrefix(session.getUserProperties(), "enforceSkip.");
        HashSet<Project> changed = new HashSet<Project>();
        for (Project project : projects) {
            String ga = IdUtils.ga(project);
            EnforcingMode mode = state.getEnforcingMode();
            String override = excluded.get(ga);
            if (override != null) {
                mode = EnforcingMode.getMode(override);
            }
            if (mode == EnforcingMode.none) {
                this.logger.info("Install/Deploy skip-flag enforcement is disabled for: {}.", (Object)ga);
                continue;
            }
            this.logger.info(this.getClass().getSimpleName() + " applying skip-flag enforment mode of: " + (Object)((Object)mode) + " to: " + ga);
            Model model = project.getModel();
            Boolean baseSkipSetting = mode.defaultModificationValue();
            baseSkipSetting = this.enforceSkipFlag((ModelBase)model, baseSkipSetting, project, changed, true);
            List profiles = model.getProfiles();
            if (profiles == null) continue;
            for (Profile profile : model.getProfiles()) {
                this.enforceSkipFlag((ModelBase)profile, baseSkipSetting, project, changed, false);
            }
        }
        return changed;
    }

    private Boolean enforceSkipFlag(ModelBase base, Boolean baseSkipSetting, Project project, Set<Project> changed, boolean detectFlagValue) throws ManipulationException {
        Boolean skipSetting = baseSkipSetting;
        List<SkipReference> skipRefs = this.findSkipRefs(base, MAVEN_INSTALL_ARTIFACTID, project);
        if (!skipRefs.isEmpty()) {
            SkipReference ref;
            ConfigurationContainer container;
            if (detectFlagValue && skipSetting == null && (!((container = (ref = skipRefs.get(0)).getContainer()) instanceof PluginExecution) || ((PluginExecution)container).getId().equals(DEFAULT_INSTALL_EXEC))) {
                String textVal = ref.getNode().getTextContent();
                if (textVal != null) {
                    textVal = textVal.trim();
                }
                if (textVal.length() > 0) {
                    baseSkipSetting = skipSetting = Boolean.valueOf(Boolean.parseBoolean(textVal));
                }
            }
        } else if (detectFlagValue && skipSetting == null) {
            skipSetting = false;
        }
        if (skipSetting == null) {
            this.logger.warn("No setting to enforce for skip-flag! Aborting enforcement...");
            return null;
        }
        if (!skipRefs.isEmpty()) {
            for (SkipReference ref : skipRefs) {
                this.setFlag(ref, skipSetting, project, changed);
            }
        }
        if (!(skipRefs = this.findSkipRefs(base, MAVEN_DEPLOY_ARTIFACTID, project)).isEmpty()) {
            for (SkipReference ref : skipRefs) {
                this.setFlag(ref, skipSetting, project, changed);
            }
        }
        return skipSetting;
    }

    private void setFlag(SkipReference ref, Boolean skipSetting, Project project, Set<Project> changed) throws ManipulationException {
        String old = ref.getNode().getTextContent().trim();
        String nxt = Boolean.toString(skipSetting);
        ref.getNode().setTextContent(nxt);
        ref.getContainer().setConfiguration((Object)this.getConfigXml(ref.getNode()));
        if (!old.equals(nxt)) {
            changed.add(project);
        }
    }

    private Xpp3Dom getConfigXml(Node node) throws ManipulationException {
        String config = this.galleyWrapper.toXML(node.getOwnerDocument(), false).trim();
        try {
            return Xpp3DomBuilder.build((Reader)new StringReader(config));
        }
        catch (XmlPullParserException e) {
            throw new ManipulationException("Failed to re-parse plugin configuration into Xpp3Dom: %s\nConfig was:\n%s", (Throwable)e, e.getMessage(), config);
        }
        catch (IOException e) {
            throw new ManipulationException("Failed to re-parse plugin configuration into Xpp3Dom: %s\nConfig was:\n%s", (Throwable)e, e.getMessage(), config);
        }
    }

    private List<SkipReference> findSkipRefs(ModelBase base, String pluginArtifactId, Project project) throws ManipulationException {
        String key = IdUtils.ga(MAVEN_PLUGIN_GROUPID, pluginArtifactId);
        ArrayList<SkipReference> result = new ArrayList<SkipReference>();
        Map<String, Plugin> pluginMap = project.getManagedPluginMap(base);
        Plugin plugin = pluginMap.get(key);
        result.addAll(this.findSkipRefs(plugin, project));
        pluginMap = project.getPluginMap(base);
        plugin = pluginMap.get(key);
        result.addAll(this.findSkipRefs(plugin, project));
        return result;
    }

    private List<SkipReference> findSkipRefs(Plugin plugin, Project project) throws ManipulationException {
        List executions;
        if (plugin == null) {
            return Collections.emptyList();
        }
        LinkedHashMap<Object, String> configs = new LinkedHashMap<Object, String>();
        Object configuration = plugin.getConfiguration();
        if (configuration != null) {
            configs.put(plugin, configuration.toString());
        }
        if ((executions = plugin.getExecutions()) != null) {
            for (PluginExecution execution : executions) {
                configuration = execution.getConfiguration();
                if (configuration == null) continue;
                configs.put(execution, configuration.toString());
            }
        }
        ArrayList<SkipReference> result = new ArrayList<SkipReference>();
        for (Map.Entry entry : configs.entrySet()) {
            try {
                Document doc = this.galleyWrapper.parseXml((String)entry.getValue());
                NodeList children = doc.getDocumentElement().getChildNodes();
                if (children == null) continue;
                for (int i = 0; i < children.getLength(); ++i) {
                    Node n = children.item(i);
                    if (!n.getNodeName().equals(SKIP_NODE)) continue;
                    result.add(new SkipReference((ConfigurationContainer)entry.getKey(), n));
                }
            }
            catch (GalleyMavenXMLException e) {
                throw new ManipulationException("Unable to parse config for plugin: %s in: %s", (Throwable)e, plugin.getId(), project.getId());
            }
        }
        return result;
    }

    @Override
    public int getExecutionIndex() {
        return 70;
    }

    private static final class SkipReference {
        private final ConfigurationContainer container;
        private final Node node;

        public SkipReference(ConfigurationContainer container, Node node) {
            this.container = container;
            this.node = node;
        }

        public ConfigurationContainer getContainer() {
            return this.container;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

