/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.ManipulationSession;
import org.commonjava.maven.ext.manip.impl.Manipulator;
import org.commonjava.maven.ext.manip.io.ModelIO;
import org.commonjava.maven.ext.manip.model.Project;
import org.commonjava.maven.ext.manip.state.ProfileInjectionState;
import org.commonjava.maven.ext.manip.util.IdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=Manipulator.class, hint="profile-injection")
public class ProfileInjectionManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Requirement
    protected ModelIO modelBuilder;

    @Override
    public void scan(List<Project> projects, ManipulationSession session) throws ManipulationException {
    }

    @Override
    public void init(ManipulationSession session) {
        Properties userProps = session.getUserProperties();
        session.setState(new ProfileInjectionState(userProps));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects, ManipulationSession session) throws ManipulationException {
        ProfileInjectionState state = session.getState(ProfileInjectionState.class);
        if (!session.isEnabled() || !state.isEnabled()) {
            this.logger.debug(this.getClass().getSimpleName() + ": Nothing to do!");
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        Model remoteModel = this.modelBuilder.resolveRawModel(state.getRemoteProfileInjectionMgmt());
        List remoteProfiles = remoteModel.getProfiles();
        for (Project project : projects) {
            if (!project.isInheritanceRoot()) continue;
            String ga = IdUtils.ga(project);
            this.logger.info(this.getClass().getSimpleName() + " applying changes to: " + ga);
            Model model = project.getModel();
            List profiles = model.getProfiles();
            Iterator i = remoteProfiles.iterator();
            while (i.hasNext()) {
                this.addProfile(profiles, (Profile)i.next());
            }
            changed.add(project);
        }
        return changed;
    }

    private void addProfile(List<Profile> profiles, Profile profile) {
        Iterator<Profile> i = profiles.iterator();
        while (i.hasNext()) {
            Profile p = i.next();
            if (profile.getId().equals(p.getId())) {
                this.logger.debug("Removing local profile {} ", (Object)p);
                i.remove();
            }
            if (p.getActivation() == null || !p.getActivation().isActiveByDefault()) continue;
            this.logger.warn("Profile {} is activeByDefault", (Object)p);
            Activation replacement = new Activation();
            ActivationProperty replacementProp = new ActivationProperty();
            replacementProp.setName("!disableProfileActivation");
            replacement.setProperty(replacementProp);
            p.setActivation(replacement);
        }
        this.logger.debug("Adding profile {}", (Object)profile);
        profiles.add(profile);
    }

    @Override
    public int getExecutionIndex() {
        return 50;
    }
}

