/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.ManipulationSession;
import org.commonjava.maven.ext.manip.impl.Manipulator;
import org.commonjava.maven.ext.manip.model.Project;
import org.commonjava.maven.ext.manip.state.ProjectSourcesInjectingState;
import org.commonjava.maven.ext.manip.state.State;
import org.commonjava.maven.ext.manip.util.IdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=Manipulator.class, hint="project-sources")
public class ProjectSourcesInjectingManipulator
implements Manipulator {
    private static final String PROJECT_SOURCES_GID = "org.commonjava.maven.plugins";
    private static final String PROJECT_SOURCES_AID = "project-sources-maven-plugin";
    private static final String PROJECT_SOURCES_COORD = IdUtils.ga("org.commonjava.maven.plugins", "project-sources-maven-plugin");
    private static final String BMMP_GID = "com.redhat.rcm.maven.plugin";
    private static final String BMMP_AID = "buildmetadata-maven-plugin";
    private static final String BMMP_COORD = IdUtils.ga("com.redhat.rcm.maven.plugin", "buildmetadata-maven-plugin");
    private static final String BMMP_GOAL = "provide-buildmetadata";
    private static final String BMMP_EXEC_ID = "build-metadata";
    private static final String PROJECT_SOURCES_GOAL = "archive";
    private static final String PROJECT_SOURCES_EXEC_ID = "project-sources-archive";
    private static final String VALIDATE_PHASE = "validate";
    private static final String INITIALIZE_PHASE = "initialize";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void init(ManipulationSession session) throws ManipulationException {
        session.setState(new ProjectSourcesInjectingState(session.getUserProperties()));
    }

    @Override
    public void scan(List<Project> projects, ManipulationSession session) throws ManipulationException {
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects, ManipulationSession session) throws ManipulationException {
        ProjectSourcesInjectingState state = session.getState(ProjectSourcesInjectingState.class);
        if (state.isEnabled() && session.anyStateEnabled(State.activeByDefault)) {
            for (Project project : projects) {
                PluginExecution execution;
                if (!project.isExecutionRoot()) continue;
                this.logger.info("Examining {} to apply sources/metadata plugins.", (Object)project);
                Model model = project.getModel();
                Build build = model.getBuild();
                if (build == null) {
                    build = new Build();
                    model.setBuild(build);
                }
                boolean changed = false;
                Map pluginMap = build.getPluginsAsMap();
                if (state.isProjectSourcesPluginEnabled() && !pluginMap.containsKey(PROJECT_SOURCES_COORD)) {
                    execution = new PluginExecution();
                    execution.setId(PROJECT_SOURCES_EXEC_ID);
                    execution.setPhase(INITIALIZE_PHASE);
                    execution.setGoals(Collections.singletonList(PROJECT_SOURCES_GOAL));
                    Plugin plugin = new Plugin();
                    plugin.setGroupId(PROJECT_SOURCES_GID);
                    plugin.setArtifactId(PROJECT_SOURCES_AID);
                    plugin.setVersion(state.getProjectSourcesPluginVersion());
                    plugin.addExecution(execution);
                    build.addPlugin(plugin);
                    changed = true;
                }
                if (state.isBuildMetadataPluginEnabled() && !pluginMap.containsKey(BMMP_COORD)) {
                    execution = new PluginExecution();
                    execution.setId(BMMP_EXEC_ID);
                    execution.setPhase(VALIDATE_PHASE);
                    execution.setGoals(Collections.singletonList(BMMP_GOAL));
                    Xpp3Dom xml = new Xpp3Dom("configuration");
                    HashMap<String, Object> config = new HashMap<String, Object>();
                    config.put("createPropertiesReport", true);
                    config.put("createXmlReport", false);
                    config.put("hideCommandLineInfo", false);
                    config.put("hideMavenOptsInfo", false);
                    config.put("hideJavaOptsInfo", false);
                    config.put("activateOutputFileMapping", false);
                    config.put("propertiesOutputFile", "${basedir}/build.metadata");
                    config.put("addJavaRuntimeInfo", true);
                    config.put("addMavenExecutionInfo", true);
                    config.put("addLocallyModifiedTagToFullVersion", false);
                    config.put("addToGeneratedSources", false);
                    config.put("validateCheckout", false);
                    config.put("forceNewProperties", true);
                    for (Map.Entry entry : config.entrySet()) {
                        Xpp3Dom child = new Xpp3Dom((String)entry.getKey());
                        if (entry.getValue() != null) {
                            child.setValue(entry.getValue().toString());
                        }
                        xml.addChild(child);
                    }
                    execution.setConfiguration((Object)xml);
                    Plugin plugin = new Plugin();
                    plugin.setGroupId(BMMP_GID);
                    plugin.setArtifactId(BMMP_AID);
                    plugin.setVersion(state.getBuildMetadataPluginVersion());
                    plugin.addExecution(execution);
                    plugin.setInherited(false);
                    build.addPlugin(plugin);
                    changed = true;
                }
                if (!changed) continue;
                return Collections.singleton(project);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public int getExecutionIndex() {
        return 30;
    }
}

